import {getCssClasses, getGroupNames} from "./edm-config-functions";

AJS.toInit(function () {
    // ----------------Save-Button-Space------------------------
    const getSpaceConfigSaveData = function (spaceKey) {
        return {
            spaceKey: spaceKey,
            groupList: JSON.stringify(getGroupNames()),
            cssClasses: JSON.stringify(getCssClasses())
        };
    };

    AJS.$('#edm-space-save-button').click(function () {
        const url = AJS.params.baseUrl + "/rest/edm/1.0/edm/save/statusSpaceSettings";
        const spaceKey = AJS.params.spaceKey;

        Edm.Rest.post(url, getSpaceConfigSaveData(spaceKey), function () {
            Edm.Flag.spaceSettingsSuccessFlag();
        });
    });
});
