if (typeof Edm === "undefined") {
    Edm = {};
}
Edm.Flag = {};

Edm.Flag.newFlag = function (type, title, description) {
    let body = `<p><strong>${title}</strong></p>`;
    if (description !== undefined) {
        body = body.concat(`<p>${description}</p>`);
    }
    return AJS.flag({
        type: type,
        body: body,
    });
};

Edm.Flag.dropdownNotUpdatedInDraft = function () {
    const flag = Edm.Flag.newFlag("warning", "Dropdown might not have been updated in draft!");
    setTimeout(flag.close, 3000);
};

Edm.Flag.someOptionsGotDeletedCauseInvalidName = function () {
    Edm.Flag.newFlag("warning", "Some options of the set have been deleted because the field for the value was left empty")
};

Edm.Flag.restoredOptionSuccessFully = function () {
    const flag = Edm.Flag.newFlag("success", "Restored option successfully");
    setTimeout(flag.close, 2000);
};

Edm.Flag.rememberToSaveFlag = function () {
    const flag = Edm.Flag.newFlag("warning", "Remember to save the Changes you made");
    setTimeout(flag.close, 2000);
};

Edm.Flag.spaceSettingsSuccessFlag = function () {
    const flag = Edm.Flag.newFlag("success", "Settings have been saved!");
    setTimeout(flag.close, 3000);
};

Edm.Flag.updateDropdownSuccessFlag = function () {
    const flag = Edm.Flag.newFlag("success", "Updated successfully!");
    setTimeout(flag.close, 3000);
}

Edm.Flag.importSettingsSuccessFlag = function () {
    const flag = Edm.Flag.newFlag("success", "Import was successful!");
    setTimeout(flag.close, 3000);
}

Edm.Flag.newErrorFlagUnknownError = function (resp) {
    var code = (resp["status-code"] === undefined || resp["status-code"] === null) ? "(unknown)" : resp["status-code"];
    var responseText = (resp.responseText === undefined || resp.responseText === null) ? "No text." : resp.responseText;
    Edm.Flag.newFlag("error", "Error " + code+":", responseText);
};

Edm.Flag.errorOutput = function (err) {
    console.log("Easy Dropdown Menu Error", err);
    var resp = {
        "status-code": err.status,
        "responseText": err.responseText
    };
    Edm.Flag.newErrorFlagUnknownError(resp);
};

Edm.Flag.readOnlyModeFlag = function () {
    Edm.Flag.newFlag("warning",
        "Attention read-only mode is active!",
        "All changes will not be saved.")
}
