/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.taskUtils.tasks;

import com.atlassian.confluence.pages.Page;
import eps.focuspro.migration.macroMigration.SchemaVersion1Updater;
import eps.focuspro.search.MappingExecuter;
import eps.focuspro.search.PageSearcher;
import eps.focuspro.taskUtils.core.EdmLongRunningTask;
import eps.focuspro.taskUtils.core.ResponseData;
import eps.focuspro.taskUtils.core.SuccessEventData;
import eps.focuspro.taskUtils.core.TaskManager;
import eps.focuspro.taskUtils.helper.PageUrlMappingProvider;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroUpdateTask
extends EdmLongRunningTask {
    private TaskManager taskManager;
    private final Logger log = LoggerFactory.getLogger(MacroUpdateTask.class);
    private SchemaVersion1Updater schemaVersion1Updater;
    private PageSearcher pageSearcher;
    private MappingExecuter mappingExecuter;
    private PageUrlMappingProvider pageUrlMappingProvider;

    public MacroUpdateTask(TaskManager taskManager, SchemaVersion1Updater schemaVersion1Updater, PageSearcher pageSearcher, MappingExecuter mappingExecuter, PageUrlMappingProvider pageUrlMappingProvider) {
        this.taskManager = taskManager;
        this.schemaVersion1Updater = schemaVersion1Updater;
        this.pageSearcher = pageSearcher;
        this.mappingExecuter = mappingExecuter;
        this.pageUrlMappingProvider = pageUrlMappingProvider;
    }

    protected void runInternal() {
        this.runMigration();
    }

    private void runMigration() {
        this.progress.setStatus("Starting Macro Migration of Macros with SchemaVersion 1");
        try {
            Map<String, Set<String>> pageMapping = this.pageSearcher.getPagesMappingForMacroName("easy-dropdown-menu-edit-mode", "easy-dropdown-menu-predefined", "easy-dropdown-menu-status");
            int total = this.mappingExecuter.getTotal(pageMapping) + 2;
            this.progress.setTotalObjects(total);
            this.progress.setCurrentCount(1);
            List<Long> updatedPages = this.mappingExecuter.handlePages(pageMapping, page -> {
                this.progress.setCurrentCount(this.progress.getCurrentCount() + 1);
                return this.schemaVersion1Updater.migratePage((Page)page);
            });
            String successMessage = "Updated a total of " + updatedPages.size() + " pages";
            this.updateCompletedTaskState(new ResponseData(new SuccessEventData(successMessage, this.pageUrlMappingProvider.getPageMappings(updatedPages))), successMessage, true);
            this.progress.setStatus(successMessage);
        }
        catch (Exception e) {
            this.log.error("Exception while trying to migrate macros with SchemaVersion 1");
            this.updateCompletedTaskState(new ResponseData(500, (Serializable)((Object)e.getMessage())), "Edm Update Task Aborted", false);
        }
    }

    private void updateCompletedTaskState(ResponseData response, String status, boolean successful) {
        this.taskManager.add(this.getResponseId(), response);
        this.progress.setStatus(status);
        this.progress.setPercentage(100);
        this.progress.setCompletedSuccessfully(successful);
    }

    public String getName() {
        return "EDM Macro Schema Version 1 Migration Process";
    }
}

