/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.search.core;

import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.MacroUsageQuery;
import com.atlassian.confluence.search.v2.query.WildcardTextFieldQuery;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultProvider {
    private static final Logger log = LoggerFactory.getLogger(SearchResultProvider.class);
    private final SearchManager searchManager;

    public SearchResultProvider(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    public List<SearchResult> searchMacroName(String macroName) {
        ISearch iSearch = ((ContentSearch.Builder)((ContentSearch.Builder)((ContentSearch.Builder)ContentSearch.builder().query((SearchQuery)new MacroUsageQuery(macroName))).startOffset(0)).limit(100000000)).build();
        return this.doContentSearch(iSearch);
    }

    public List<SearchResult> searchFieldName(String fieldName) {
        ISearch iSearch = ((ContentSearch.Builder)((ContentSearch.Builder)((ContentSearch.Builder)((ContentSearch.Builder)ContentSearch.builder().query((SearchQuery)new WildcardTextFieldQuery(fieldName, "*", BooleanOperator.AND))).sort((SearchSort)new ModifiedSort(SearchSort.Order.DESCENDING))).startOffset(0)).limit(100000000)).build();
        return this.doContentSearch(iSearch);
    }

    private List<SearchResult> doContentSearch(ISearch iSearch) {
        try {
            SearchResults search = this.searchManager.search(iSearch);
            if (search != null) {
                return search.getAll();
            }
        }
        catch (InvalidSearchException e) {
            log.warn("Exception occurred getting SearchResults", (Throwable)e);
        }
        return Collections.emptyList();
    }
}

