/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest.page;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.gson.Gson;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.macros.EdmMacroUtils;
import eps.focuspro.rest.dtos.NonPredefinedMacroInput;
import eps.focuspro.rest.dtos.PredefinedMacroInput;
import eps.focuspro.rest.dtos.UpdateMacroRespDto;
import eps.focuspro.rest.helper.EdmPageManager;
import eps.focuspro.rest.helper.MacroLogger;
import eps.focuspro.rest.helper.ResourceContext;
import eps.focuspro.rest.helper.ResourceContextBuilder;
import eps.focuspro.rest.helper.ResourcesRunner;
import eps.focuspro.rest.helper.exceptions.DataNotFoundException;
import eps.focuspro.rest.helper.exceptions.MacroIdException;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/page")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MacroUpdateResources {
    private final ResourcesRunner resourcesRunner;
    private final MacroLogger macroLogger;
    private final EdmPageManager edmPageManager;
    private final PageManager pageManager;
    private final DraftsTransitionHelper draftsTransitionHelper;
    private final EdmSettingsManager edmSettingsManager;

    @Inject
    public MacroUpdateResources(ResourcesRunner resourcesRunner, MacroLogger macroLogger, EdmPageManager edmPageManager, PageManager pageManager, DraftsTransitionHelper draftsTransitionHelper, EdmSettingsManager edmSettingsManager) {
        this.resourcesRunner = resourcesRunner;
        this.macroLogger = macroLogger;
        this.edmPageManager = edmPageManager;
        this.pageManager = pageManager;
        this.draftsTransitionHelper = draftsTransitionHelper;
        this.edmSettingsManager = edmSettingsManager;
    }

    @AnonymousSiteAccess
    @POST
    @Path(value="/update/predefined-macro")
    @ReadOnlyAccessBlocked
    public Response updatePredefinedMacro(PredefinedMacroInput input) {
        long pageId = input.pageId;
        return this.resourcesRunner.run(() -> {
            Page page = this.pageManager.getPage(pageId);
            this.checkPreconditions(page, input.macroId);
            this.macroLogger.logMacrosOfPage(pageId, "UPDATE_MACRO BEFORE ::: data={macroId:'" + input.macroId + "',optionId:'" + input.optionId + "',optionValue:'" + input.currentOptionValue + "'}");
            ResourceContext context = new ResourceContextBuilder().withPluginLicense().withPageEditPermission(pageId).build();
            Response response = this.resourcesRunner.run(() -> {
                MacroDefinitionUpdater macroDefinitionUpdater = this.getPredefinedMacroUpdater(input.macroId, input.optionId, input.currentOptionValue);
                this.edmPageManager.updatePage(page, macroDefinitionUpdater, input.silentUpdate);
                return Response.ok((Object)new Gson().toJson((Object)new UpdateMacroRespDto(this.isMacroFoundInPageAndDraft(page, input.macroId), this.edmSettingsManager.getGlobalSettings().isSuppressNotifications())), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }, context);
            this.macroLogger.logMacrosOfPage(pageId, "UPDATE_MACRO AFTER");
            return response;
        }, new ResourceContextBuilder().withPageEditPermission(pageId).build());
    }

    @AnonymousSiteAccess
    @POST
    @Path(value="/update/non-predefined-macro")
    @ReadOnlyAccessBlocked
    public Response updateNonPredefinedMacro(NonPredefinedMacroInput input) {
        long pageId = input.pageId;
        return this.resourcesRunner.run(() -> {
            Page page = this.pageManager.getPage(pageId);
            this.checkPreconditions(page, input.macroId);
            ResourceContext context = new ResourceContextBuilder().withoutMigrationCheck().withPluginLicense().withPageEditPermission(pageId).build();
            this.macroLogger.logMacrosOfPage(pageId, "UPDATE_MACRO BEFORE ::: data={macroId:'" + input.macroId + "',option:'" + input.currentOption + "'}");
            Response response = this.resourcesRunner.run(() -> {
                this.edmPageManager.updatePage(page, this.getToggleMacroNonPredefinedDefinitionUpdater(input.macroId, input.currentOption), input.silentUpdate);
                return Response.ok((Object)new Gson().toJson((Object)new UpdateMacroRespDto(this.isMacroFoundInPageAndDraft(page, input.macroId), this.edmSettingsManager.getGlobalSettings().isSuppressNotifications())), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }, context);
            this.macroLogger.logMacrosOfPage(pageId, "UPDATE_MACRO AFTER");
            return response;
        }, new ResourceContextBuilder().withPageEditPermission(pageId).build());
    }

    private void checkPreconditions(Page page, String macroId) {
        if (page == null) {
            throw new DataNotFoundException("Couldn't find page to update");
        }
        boolean macroOnPage = page.getBodyAsString().contains(macroId);
        if (!macroOnPage) {
            throw new MacroIdException("Update failed because the macro Id on the Page doesn't match any saved macro. There is a known Issue that causes this when \"Published View Macro Transform\" is enabled in Comala Document Management.");
        }
    }

    private MacroDefinitionUpdater getPredefinedMacroUpdater(String macroId, String currentOptionIds, String currentOptionValue) {
        return macroDefinition -> {
            String currentMacroId = EdmMacroUtils.getMacroId(macroDefinition);
            if (currentMacroId != null && StringUtils.equals((CharSequence)currentMacroId, (CharSequence)macroId)) {
                macroDefinition.setTypedParameter("option-id", (Object)currentOptionIds.trim());
                macroDefinition.setTypedParameter("current-option-value", (Object)currentOptionValue);
            }
            return macroDefinition;
        };
    }

    private MacroDefinitionUpdater getToggleMacroNonPredefinedDefinitionUpdater(String macroId, String parameterValue) {
        return macroDefinition -> {
            String currentMacroId = EdmMacroUtils.getMacroId(macroDefinition);
            if (currentMacroId != null && StringUtils.equals((CharSequence)currentMacroId, (CharSequence)macroId)) {
                macroDefinition.setTypedParameter("current-option", (Object)parameterValue.trim());
            }
            return macroDefinition;
        };
    }

    private boolean isMacroFoundInPageAndDraft(Page page, String macroId) {
        ContentEntityObject draft = this.draftsTransitionHelper.getDraftForPage((AbstractPage)page);
        if (draft != null) {
            String pageBody = page.getBodyAsString();
            String draftBody = draft.getBodyAsString();
            return pageBody.contains(macroId) && draftBody.contains(macroId);
        }
        return true;
    }
}

