/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest.helper;

import eps.focuspro.PermissionValidator;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.license.LicenseStatus;
import eps.focuspro.license.LicenseValidator;
import eps.focuspro.rest.helper.ExecutionGuard;
import eps.focuspro.rest.helper.ResourceContext;
import eps.focuspro.rest.helper.exceptions.PermissionValidationException;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesRunner
extends ExecutionGuard {
    private final LicenseValidator licenseValidator;
    private final PermissionValidator permissionValidator;
    private static final Logger log = LoggerFactory.getLogger(ResourcesRunner.class);
    private final EdmSettingsManager edmSettingsManager;

    public ResourcesRunner(LicenseValidator licenseValidator, PermissionValidator permissionValidator, EdmSettingsManager edmSettingsManager) {
        this.licenseValidator = licenseValidator;
        this.permissionValidator = permissionValidator;
        this.edmSettingsManager = edmSettingsManager;
    }

    public Response run(Callable<Response> callable, ResourceContext resourceContext) {
        return this.execute(() -> {
            LicenseStatus licenseStatus;
            if (resourceContext.isNeedGlobalAdmin()) {
                this.checkAdmin();
            }
            if (resourceContext.isNeedSpaceAdmin()) {
                this.checkSpaceAdmin(resourceContext.getSpaceKey());
            }
            if (resourceContext.isNeedEditPermission()) {
                this.checkPageEditPermission(resourceContext.getPageId());
            }
            if (resourceContext.isNeedPluginLicense() && (licenseStatus = this.licenseValidator.validatePluginLicense()) != LicenseStatus.VALID) {
                return this.licenseValidator.getResponse(licenseStatus);
            }
            return (Response)callable.call();
        });
    }

    private void checkAdmin() {
        if (!this.permissionValidator.isCurrentUserAdmin()) {
            String message = "Admin rights required";
            log.error(message);
            throw new PermissionValidationException(message);
        }
    }

    private void checkSpaceAdmin(String spaceKey) {
        if (!this.permissionValidator.isCurrentUserSpaceAdmin(spaceKey)) {
            String message = "Space Admin rights required";
            log.error(message);
            throw new PermissionValidationException(message);
        }
    }

    private void checkPageEditPermission(long pageId) {
        boolean hasEditPermission = this.permissionValidator.isEditingAllowed(pageId, this.edmSettingsManager.getGlobalSettings());
        if (!hasEditPermission) {
            String message = "No edit permission granted";
            log.error(message);
            throw new PermissionValidationException(message);
        }
    }
}

