/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest.helper;

import eps.focuspro.rest.helper.ResourceContext;

public class ResourceContextBuilder {
    private boolean needGlobalAdminRights = false;
    private boolean needSpaceAdminRights = false;
    private boolean needValidPluginLicense = false;
    private boolean needPageEditPermission = false;
    private boolean needsNoMigrationCheck = true;
    private long pageId = 0L;
    private String spaceKey = "";

    public ResourceContextBuilder withGlobalAdminRights() {
        this.needGlobalAdminRights = true;
        return this;
    }

    public ResourceContextBuilder withSpaceAdminRights(String spaceKey) {
        this.spaceKey = spaceKey;
        this.needSpaceAdminRights = true;
        return this;
    }

    public ResourceContextBuilder withPluginLicense() {
        this.needValidPluginLicense = true;
        return this;
    }

    public ResourceContextBuilder withPageEditPermission(long pageId) {
        this.pageId = pageId;
        this.needPageEditPermission = true;
        return this;
    }

    public ResourceContextBuilder withoutMigrationCheck() {
        this.needsNoMigrationCheck = false;
        return this;
    }

    public ResourceContext build() {
        return new ResourceContext(this.needGlobalAdminRights, this.needSpaceAdminRights, this.needValidPluginLicense, this.spaceKey, this.needPageEditPermission, this.pageId);
    }
}

