/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest.helper;

import eps.focuspro.rest.helper.MigrationInProgressException;
import eps.focuspro.rest.helper.exceptions.DataNotFoundException;
import eps.focuspro.rest.helper.exceptions.DuplicatedDataException;
import eps.focuspro.rest.helper.exceptions.LicenseValidationException;
import eps.focuspro.rest.helper.exceptions.PermissionValidationException;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionGuard {
    private static final Logger log = LoggerFactory.getLogger(ExecutionGuard.class);

    protected Response execute(Callable<Response> callable) {
        try {
            return callable.call();
        }
        catch (LicenseValidationException e) {
            log.warn("Error With License Exception: {}", (Object)e.getMessage());
            return this.getResponse(500, e);
        }
        catch (DuplicatedDataException e) {
            log.warn("Error Duplicated Data Exception: {}", (Object)e.getMessage());
            return this.getResponse(500, e);
        }
        catch (PermissionValidationException e) {
            log.warn("Error Permission Exception: {}", (Object)e.getMessage());
            return this.getResponse(403, e);
        }
        catch (DataNotFoundException e) {
            log.error("Error No Data Exception: {}", (Object)e.getMessage());
            return this.getResponse(500, e);
        }
        catch (MigrationInProgressException e) {
            log.error("Error Migration in Progress: {}", (Object)e.getMessage());
            return this.getResponse(503, e);
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
            return this.getResponse(500, e);
        }
    }

    private Response getResponse(int status, Exception e) {
        return Response.status((int)status).entity((Object)e.getMessage()).build();
    }
}

