/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.gson.Gson;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.EdmCopyService;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.update.SetUpdater;
import eps.focuspro.rest.dtos.DropdownSetComplete;
import eps.focuspro.rest.edmindexing.EdmReIndexer;
import eps.focuspro.rest.helper.ResourceContextBuilder;
import eps.focuspro.rest.helper.ResourcesRunner;
import eps.focuspro.rest.helper.exceptions.DataNotFoundException;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

@Path(value="/set")
public class SetResources {
    private final ResourcesRunner resourcesRunner;
    private final SetUpdater setUpdater;
    private final EdmReIndexer edmReIndexer;
    private final SetEntityAccessor setEntityAccessor;
    private final EdmCopyService edmCopyService;

    @Inject
    public SetResources(ResourcesRunner resourcesRunner, SetUpdater setUpdater, EdmReIndexer edmReIndexer, SetEntityAccessor setEntityAccessor, EdmCopyService edmCopyService) {
        this.resourcesRunner = resourcesRunner;
        this.setUpdater = setUpdater;
        this.edmReIndexer = edmReIndexer;
        this.setEntityAccessor = setEntityAccessor;
        this.edmCopyService = edmCopyService;
    }

    @AnonymousSiteAccess
    @GET
    @Path(value="/status")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    public Response getStatusSet(@QueryParam(value="setId") @DefaultValue(value="0") String setId) {
        return this.resourcesRunner.run(() -> {
            DropdownSet<LozengeOption> dropdownSet = this.setEntityAccessor.getLozengeSet(setId);
            if (dropdownSet == null) {
                throw new DataNotFoundException("The status set with id: " + setId + " couldn't be found");
            }
            return Response.ok((Object)new Gson().toJson(dropdownSet), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().withoutMigrationCheck().build());
    }

    @POST
    @Path(value="/status")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    public Response createStatusSet(DropdownSetComplete<LozengeOption> set) {
        ResourceContextBuilder resourceContextBuilder = this.getResourceContextBuilderForSpaceKey(set.spaceKey);
        return this.resourcesRunner.run(() -> {
            this.setUpdater.createStatusSet(set.name, set.id, set.spaceKey, new ArrayList<LozengeOption>());
            return Response.ok((Object)new Gson().toJson((Object)("New Status Set created with id: " + set.id + " and name: " + set.name)), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, resourceContextBuilder.withoutMigrationCheck().withPluginLicense().build());
    }

    @PUT
    @Path(value="/status")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    public Response updateStatusSet(DropdownSetComplete<LozengeOption> set) {
        ResourceContextBuilder resourceContextBuilder = this.getResourceContextBuilderForSpaceKey(set.spaceKey);
        return this.resourcesRunner.run(() -> {
            this.setUpdater.updateStatusSet(set);
            this.edmReIndexer.reIndexSetIds(set.id);
            return Response.ok((Object)new Gson().toJson((Object)("Updated Status Set with id: " + set.id + " and name: " + set.name)), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, resourceContextBuilder.withoutMigrationCheck().withPluginLicense().build());
    }

    @DELETE
    @Path(value="/status")
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    public Response deleteStatusSet(@QueryParam(value="setId") @DefaultValue(value="0") String setId, @QueryParam(value="spaceKey") @DefaultValue(value="") String spaceKey) {
        ResourceContextBuilder resourceContextBuilder = this.getResourceContextBuilderForSpaceKey(spaceKey);
        return this.resourcesRunner.run(() -> {
            this.setUpdater.deleteStatusSet(setId, spaceKey);
            this.edmReIndexer.reIndexSetIds(setId);
            return Response.ok((Object)new Gson().toJson((Object)("Deleted StatusSet with id: " + setId)), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, resourceContextBuilder.withoutMigrationCheck().withPluginLicense().build());
    }

    @GET
    @Path(value="/text")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    public Response getTextSet(@QueryParam(value="setId") @DefaultValue(value="0") String setId) {
        return this.resourcesRunner.run(() -> {
            DropdownSet<TextOption> dropdownSet = this.setEntityAccessor.getTextSet(setId);
            if (dropdownSet == null) {
                throw new DataNotFoundException("The text set with id: " + setId + " couldn't be found");
            }
            return Response.ok((Object)new Gson().toJson(dropdownSet), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().withoutMigrationCheck().build());
    }

    @POST
    @Path(value="/text")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    public Response createTextSet(DropdownSetComplete<TextOption> set) {
        return this.resourcesRunner.run(() -> {
            this.setUpdater.createTextSet(set.name, set.id, set.spaceKey, new ArrayList<TextOption>());
            return Response.ok((Object)new Gson().toJson((Object)("New Text Set created with id: " + set.id + " and name: " + set.name)), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, this.getResourceContextBuilderForSpaceKey(set.spaceKey).withoutMigrationCheck().withPluginLicense().build());
    }

    @PUT
    @Path(value="/text")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    public Response updateTextSet(DropdownSetComplete<TextOption> set) {
        return this.resourcesRunner.run(() -> {
            this.setUpdater.updateTextSet(set);
            this.edmReIndexer.reIndexSetIds(set.id);
            return Response.ok((Object)new Gson().toJson((Object)("Updated Text Set with id: " + set.id + " and name: " + set.name)), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, this.getResourceContextBuilderForSpaceKey(set.spaceKey).withoutMigrationCheck().withPluginLicense().build());
    }

    @DELETE
    @Path(value="/text")
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    public Response deleteTextSet(@QueryParam(value="setId") @DefaultValue(value="0") String setId, @QueryParam(value="spaceKey") @DefaultValue(value="") String spaceKey) {
        return this.resourcesRunner.run(() -> {
            this.setUpdater.deleteTextSet(setId, spaceKey);
            this.edmReIndexer.reIndexSetIds(setId);
            return Response.ok((Object)new Gson().toJson((Object)("Deleted StatusSet with id: " + setId)), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, this.getResourceContextBuilderForSpaceKey(spaceKey).withoutMigrationCheck().withPluginLicense().build());
    }

    @POST
    @Path(value="/copy")
    @ReadOnlyAccessBlocked
    public Response copySpaceSets(@QueryParam(value="sourceSpace") String sourceSpace, @QueryParam(value="targetSpace") String targetSpace) {
        ResourceContextBuilder resourceContextBuilder = this.getResourceContextBuilderForSpaceKey(sourceSpace);
        return this.resourcesRunner.run(() -> {
            String json = new Gson().toJson(this.edmCopyService.copyEdmSets(sourceSpace, targetSpace));
            return Response.ok((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, resourceContextBuilder.withoutMigrationCheck().withPluginLicense().build());
    }

    private ResourceContextBuilder getResourceContextBuilderForSpaceKey(@DefaultValue(value="") @QueryParam(value="spaceKey") String spaceKey) {
        ResourceContextBuilder resourceContextBuilder = new ResourceContextBuilder();
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            resourceContextBuilder.withGlobalAdminRights();
        } else {
            resourceContextBuilder.withSpaceAdminRights(spaceKey);
        }
        return resourceContextBuilder;
    }
}

