/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.gson.Gson;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.fix.DuplicationAnalyzer;
import eps.focuspro.fix.DuplicationFinder;
import eps.focuspro.fix.onpage.PageUpdater;
import eps.focuspro.migration.macroMigration.SchemaVersion1Updater;
import eps.focuspro.rest.helper.ResourceContextBuilder;
import eps.focuspro.rest.helper.ResourcesRunner;
import eps.focuspro.search.MappingExecuter;
import eps.focuspro.search.PageSearcher;
import eps.focuspro.taskUtils.core.TaskManager;
import eps.focuspro.taskUtils.dtos.ActionResponse;
import eps.focuspro.taskUtils.helper.PageUrlMappingProvider;
import eps.focuspro.taskUtils.tasks.DuplicationResolveTask;
import eps.focuspro.taskUtils.tasks.MacroUpdateTask;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@Path(value="/edm-task")
@Consumes(value={"application/json"})
@Produces(value={"text/html"})
public class RestTask {
    private final TaskManager taskManager;
    private final MappingExecuter mappingExecuter;
    private final DuplicationFinder duplicationFinder;
    private final SetEntityAccessor setEntityAccessor;
    private final PageUpdater pageUpdater;
    private final DuplicationAnalyzer duplicationAnalyzer;
    private final ActiveObjects ao;
    private final PageUrlMappingProvider pageUrlMappingProvider;
    private final TransactionTemplate transactionTemplate;
    private final ResourcesRunner resourcesRunner;
    private final SchemaVersion1Updater schemaVersion1Updater;
    private final PageSearcher pageSearcher;

    @Inject
    public RestTask(TaskManager taskManager, MappingExecuter mappingExecuter, DuplicationFinder duplicationFinder, SetEntityAccessor setEntityAccessor, PageUpdater pageUpdater, DuplicationAnalyzer duplicationAnalyzer, ActiveObjects ao, PageUrlMappingProvider pageUrlMappingProvider, TransactionTemplate transactionTemplate, ResourcesRunner resourcesRunner, SchemaVersion1Updater schemaVersion1Updater, PageSearcher pageSearcher) {
        this.taskManager = taskManager;
        this.mappingExecuter = mappingExecuter;
        this.duplicationFinder = duplicationFinder;
        this.setEntityAccessor = setEntityAccessor;
        this.pageUpdater = pageUpdater;
        this.duplicationAnalyzer = duplicationAnalyzer;
        this.ao = Objects.requireNonNull(ao);
        this.pageUrlMappingProvider = pageUrlMappingProvider;
        this.transactionTemplate = transactionTemplate;
        this.resourcesRunner = resourcesRunner;
        this.schemaVersion1Updater = schemaVersion1Updater;
        this.pageSearcher = pageSearcher;
    }

    @AnonymousSiteAccess
    @GET
    @Produces(value={"application/json"})
    @Path(value="/migrateDropDowns")
    @ReadOnlyAccessBlocked
    public Response migrateAllDropdowns() {
        return this.resourcesRunner.run(() -> {
            MacroUpdateTask task = new MacroUpdateTask(this.taskManager, this.schemaVersion1Updater, this.pageSearcher, this.mappingExecuter, this.pageUrlMappingProvider);
            String longRunningTaskId = this.taskManager.start(task);
            return Response.ok((Object)new Gson().toJson((Object)new ActionResponse(longRunningTaskId, task.getResponseId())), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().withGlobalAdminRights().build());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/resolveDuplication")
    @ReadOnlyAccessBlocked
    public Response eliminateDuplicatedStuff() {
        return this.resourcesRunner.run(() -> {
            DuplicationResolveTask task = new DuplicationResolveTask(this.taskManager, this.duplicationFinder, this.mappingExecuter, this.setEntityAccessor, this.pageUpdater, this.duplicationAnalyzer, this.ao, this.pageUrlMappingProvider, this.transactionTemplate);
            String longRunningTaskId = this.taskManager.start(task);
            return Response.ok((Object)new Gson().toJson((Object)new ActionResponse(longRunningTaskId, task.getResponseId())), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().withGlobalAdminRights().build());
    }
}

