/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.google.gson.Gson;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.rest.dtos.ConfigSettingsDto;
import eps.focuspro.rest.edmindexing.EdmReIndexer;
import eps.focuspro.rest.helper.ResourceContextBuilder;
import eps.focuspro.rest.helper.ResourcesRunner;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Path(value="/global")
@Consumes(value={"application/json"})
@Produces(value={"text/html"})
public class RestGlobalConfig {
    private final EdmReIndexer edmReIndexer;
    private final EdmSettingsManager edmSettingsManager;
    private final ResourcesRunner resourcesRunner;

    @Inject
    public RestGlobalConfig(EdmReIndexer edmReIndexer, EdmSettingsManager edmSettingsManager, ResourcesRunner resourcesRunner) {
        this.edmReIndexer = edmReIndexer;
        this.edmSettingsManager = edmSettingsManager;
        this.resourcesRunner = resourcesRunner;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/reindexAllPages")
    @ReadOnlyAccessBlocked
    public Response reIndexAllPages() {
        return this.resourcesRunner.run(() -> {
            int pageCount = this.edmReIndexer.reindexAllMacros();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("pageCount", pageCount);
            return Response.ok((Object)jsonObject.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().withoutMigrationCheck().withGlobalAdminRights().build());
    }

    @POST
    @Path(value="/save/configSettings")
    @ReadOnlyAccessBlocked
    public Response saveConfigSettings(ConfigSettingsDto input) {
        return this.resourcesRunner.run(() -> {
            List<String> groups = this.getListFromJson(input.permittedGroupNames);
            List<String> cssClasses = this.getListFromJson(input.cssClasses);
            Map<String, String> cssDefaultsMap = input.cssDefaults;
            String editModeDefault = cssDefaultsMap.get("editMode") != null ? cssDefaultsMap.get("editMode") : "";
            String nonPredefinedDefault = cssDefaultsMap.get("non-predefined") != null ? cssDefaultsMap.get("non-predefined") : "";
            String predifinedDefault = cssDefaultsMap.get("predefined") != null ? cssDefaultsMap.get("predefined") : "";
            EdmGlobalSettings edmGlobalSettings = new EdmGlobalSettings(editModeDefault, nonPredefinedDefault, predifinedDefault, input.isSuppressNotifications, input.isEdmAllowAnonymous, input.isEdmAllowWithoutEditPermission, cssClasses, groups);
            this.edmSettingsManager.saveGlobalSettings(edmGlobalSettings);
            return Response.ok((Object)new Gson().toJson((Object)"Saved Config Settings"), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().withoutMigrationCheck().withGlobalAdminRights().withPluginLicense().build());
    }

    private List<String> getListFromJson(String json) {
        JSONArray jsonArray = new JSONArray(json);
        ArrayList<String> groupList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            groupList.add(jsonArray.getString(i));
        }
        return groupList;
    }
}

