/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.google.gson.Gson;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.SetHistoryAccesor;
import eps.focuspro.edm.persistence.update.SetUpdater;
import eps.focuspro.history.historyObjects.SetHistory;
import eps.focuspro.rest.dtos.RestoreStatusOptionDto;
import eps.focuspro.rest.dtos.RestoreTextOptionDto;
import eps.focuspro.rest.helper.ResourceContextBuilder;
import eps.focuspro.rest.helper.ResourcesRunner;
import eps.focuspro.rest.helper.exceptions.DataNotFoundException;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/history")
public class HistoryResources {
    private final ResourcesRunner resourcesRunner;
    private final SetHistoryAccesor setHistoryAccesor;
    private static final Logger log = LoggerFactory.getLogger(HistoryResources.class);
    private final SetUpdater setUpdater;

    @Inject
    public HistoryResources(ResourcesRunner resourcesRunner, SetHistoryAccesor setHistoryAccesor, SetUpdater setUpdater) {
        this.resourcesRunner = resourcesRunner;
        this.setHistoryAccesor = setHistoryAccesor;
        this.setUpdater = setUpdater;
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    public Response getStatusHistory(@QueryParam(value="setId") @DefaultValue(value="0") String setId) {
        return this.resourcesRunner.run(() -> {
            SetHistory<LozengeOption> setHistory = this.setHistoryAccesor.getLozengeHistoryChange(setId);
            if (setHistory == null) {
                String message = "The status history set with id: " + setId + " could not be found";
                log.error(message);
                throw new DataNotFoundException(message);
            }
            return Response.ok((Object)new Gson().toJson(setHistory), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().withoutMigrationCheck().build());
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/status/restoreOption")
    @ReadOnlyAccessBlocked
    public Response restoreStatusOption(RestoreStatusOptionDto input) {
        ResourceContextBuilder resourceContextBuilder = new ResourceContextBuilder();
        if (StringUtils.isBlank((CharSequence)input.spaceKey)) {
            resourceContextBuilder.withGlobalAdminRights();
        } else {
            resourceContextBuilder.withSpaceAdminRights(input.spaceKey);
        }
        return this.resourcesRunner.run(() -> {
            if (StringUtils.isBlank((CharSequence)input.spaceKey)) {
                input.spaceKey = "";
            }
            this.setUpdater.restoreStatusOption(input);
            return Response.ok((Object)new Gson().toJson((Object)"Restored Successfully"), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, resourceContextBuilder.withPluginLicense().build());
    }

    @GET
    @Path(value="/text")
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    public Response getTextHistory(@QueryParam(value="setId") @DefaultValue(value="0") String setId) {
        return this.resourcesRunner.run(() -> {
            SetHistory<TextOption> setHistory = this.setHistoryAccesor.getTextHistoryChange(setId);
            if (setHistory == null) {
                String message = "The text history set with id: " + setId + " could not be found";
                log.error(message);
                throw new DataNotFoundException(message);
            }
            return Response.ok((Object)new Gson().toJson(setHistory), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().withoutMigrationCheck().build());
    }

    @POST
    @Produces
    @Path(value="text/restoreOption")
    @ReadOnlyAccessBlocked
    public Response restoreTextOption(RestoreTextOptionDto input) {
        ResourceContextBuilder resourceContextBuilder = new ResourceContextBuilder();
        if (StringUtils.isBlank((CharSequence)input.spaceKey)) {
            resourceContextBuilder.withGlobalAdminRights();
        } else {
            resourceContextBuilder.withSpaceAdminRights(input.spaceKey);
        }
        return this.resourcesRunner.run(() -> {
            if (StringUtils.isBlank((CharSequence)input.spaceKey)) {
                input.spaceKey = "";
            }
            this.setUpdater.restoreTextOption(input);
            return Response.ok((Object)new Gson().toJson((Object)"Restored Successfully"), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, resourceContextBuilder.withoutMigrationCheck().withPluginLicense().build());
    }
}

