/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.google.gson.Gson;
import eps.focuspro.taskUtils.core.ResponseData;
import eps.focuspro.taskUtils.core.SuccessEventData;
import eps.focuspro.taskUtils.core.TaskManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/completed")
public class CompletedTaskResources {
    private static final Logger log = LoggerFactory.getLogger(CompletedTaskResources.class);
    private final TaskManager taskManager;

    @Inject
    public CompletedTaskResources(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{responseId}")
    @ReadOnlyAccessAllowed
    public Response get(@PathParam(value="responseId") String responseId) {
        log.info("Trying to find the updated page ids of the finished task");
        ResponseData responseData = this.taskManager.get(responseId);
        SuccessEventData successEventData = responseData.getSuccessEventData();
        if (successEventData != null) {
            return this.createSuccessResponse(successEventData);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private Response createSuccessResponse(SuccessEventData successEventData) {
        return Response.ok((Object)new Gson().toJson((Object)successEventData), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }
}

