/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.macros;

import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.ResourceAware;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.web.UrlBuilder;
import com.google.gson.Gson;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.PermissionValidator;
import eps.focuspro.configui.OptionCalculator;
import eps.focuspro.configui.PermittedGroupsCollector;
import eps.focuspro.dropdown.dtos.DropdownDto;
import eps.focuspro.dropdown.dtos.DropdownDtoCreator;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.macros.DropdownState;
import eps.focuspro.macros.EdmMacroUtils;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DropdownMenuStatus
implements Macro,
EditorImagePlaceholder,
ResourceAware {
    public static final String MACRO_NAME = "easy-dropdown-menu-status";
    private static final String SILENT_PAGE_UPDATE = "silent-update";
    private static final int IMAGE_PLACEHOLDER_SIDE_SPACES = 15;
    private final PermittedGroupsCollector permittedGroupsCollector;
    private final PermissionValidator permissionValidator;
    private final DropdownDtoCreator dropdownDtoCreator;
    private final OptionCalculator optionCalculator;
    private final SetEntityAccessor setEntityAccessor;
    private final EdmSettingsManager edmSettingsManager;
    private final VelocityHelperService velocityHelperService;

    public DropdownMenuStatus(PermittedGroupsCollector permittedGroupsCollector, PermissionValidator permissionValidator, DropdownDtoCreator dropdownDtoCreator, OptionCalculator optionCalculator, SetEntityAccessor setEntityAccessor, EdmSettingsManager edmSettingsManager, VelocityHelperService velocityHelperService) {
        this.permittedGroupsCollector = permittedGroupsCollector;
        this.permissionValidator = permissionValidator;
        this.dropdownDtoCreator = dropdownDtoCreator;
        this.optionCalculator = optionCalculator;
        this.setEntityAccessor = setEntityAccessor;
        this.edmSettingsManager = edmSettingsManager;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) {
        DropdownDto dropdownDto = this.dropdownDtoCreator.create(parameters, conversionContext, false);
        EdmGlobalSettings databaseSettings = this.edmSettingsManager.getGlobalSettings();
        String spaceKey = conversionContext.getSpaceKey();
        long pageId = dropdownDto.getPageId();
        String currentOptionValue = parameters.get("current-option-value");
        Boolean isSilentUpdate = Boolean.parseBoolean(parameters.get(SILENT_PAGE_UPDATE));
        String dropdownSetId = parameters.get("set-id") == null ? "" : parameters.get("set-id");
        String optionId = parameters.get("option-id") == null ? "" : parameters.get("option-id");
        DropdownSet<LozengeOption> chosenLozengeSet = this.setEntityAccessor.getLozengeSet(dropdownSetId);
        DropdownState dropdownState = this.getDropdownState(chosenLozengeSet, optionId, currentOptionValue);
        if (!dropdownState.equals((Object)DropdownState.OK)) {
            return DropdownState.getMessage(dropdownState, currentOptionValue);
        }
        LozengeOption option = this.optionCalculator.getLozengeOption(chosenLozengeSet, optionId);
        String optionName = option.getName();
        String color = option.getColor();
        List<String> combinedPermittedGroups = this.permittedGroupsCollector.collect(parameters, spaceKey, databaseSettings);
        String outputType = conversionContext.getOutputType();
        if ("html_export".equals(outputType) || "pdf".equals(outputType) || "word".equals(outputType) || "email".equals(outputType)) {
            return this.getPreviewString(option.getSubtle(), option.getTextColor(), optionName, color);
        }
        boolean permissionToManipulate = this.permissionValidator.hasUserPermission(combinedPermittedGroups, pageId, databaseSettings);
        if (!permissionToManipulate || "preview".equals(outputType)) {
            return this.getPreviewString(option.getSubtle(), option.getTextColor(), optionName, color);
        }
        Object dropdownClass = "";
        if (EdmMacroUtils.isLockedAndReferenced(parameters, conversionContext)) {
            dropdownClass = (String)dropdownClass + " edm-referenced-dropdown";
        }
        if (EdmMacroUtils.getBoolean(parameters, "locked-in-page-property-report", false)) {
            dropdownClass = (String)dropdownClass + " edm-lockedInPagePropertyReport-dropdown";
        }
        Map<String, Object> velocityMap = this.getVelocityMap(chosenLozengeSet.getOptionsList(), optionName, option.getId(), color, dropdownDto.getMacroId(), pageId, option.getSubtle(), option.getTextColor(), (String)dropdownClass, isSilentUpdate);
        return this.velocityHelperService.getRenderedTemplate("velocity/dropdown-status-menu.vm", velocityMap);
    }

    private DropdownState getDropdownState(DropdownSet<LozengeOption> chosenLozengeSet, String optionId, String currentOptionValue) {
        if (chosenLozengeSet == null) {
            if (currentOptionValue != null) {
                return DropdownState.SET_NOT_FOUND_VALUE_WAS;
            }
            return DropdownState.SET_NOT_FOUND;
        }
        LozengeOption option = this.optionCalculator.getLozengeOption(chosenLozengeSet, optionId);
        if (option == null) {
            if (currentOptionValue != null) {
                return DropdownState.OPTION_NOT_FOUND;
            }
            return DropdownState.EMPTY_SET;
        }
        return DropdownState.OK;
    }

    private String getPreviewString(boolean subtle, boolean textWhite, String optionName, String color) {
        return this.velocityHelperService.getRenderedTemplate("velocity/dropdown-status-menu-export.vm", this.getSimpleVelocityMap(subtle, textWhite, optionName, color));
    }

    private Map<String, Object> getSimpleVelocityMap(boolean subtle, boolean textWhite, String optionName, String color) {
        HashMap<String, Object> velocityMap = new HashMap<String, Object>();
        velocityMap.put("subtle", subtle);
        velocityMap.put("textWhite", textWhite);
        velocityMap.put("color", color);
        velocityMap.put("optionName", optionName);
        return velocityMap;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> parameters, ConversionContext conversionContext) {
        String textToDisplay;
        String color = "";
        boolean subtle = true;
        boolean textWhite = true;
        String dropdownSetId = parameters.get("set-id") == null ? "" : parameters.get("set-id");
        String optionId = parameters.get("option-id") == null ? "" : parameters.get("option-id");
        String currentOptionValue = parameters.get("current-option-value");
        DropdownSet<LozengeOption> chosenLozengeSet = this.setEntityAccessor.getLozengeSet(dropdownSetId);
        DropdownState dropdownState = this.getDropdownState(chosenLozengeSet, optionId, currentOptionValue);
        if (!dropdownState.equals((Object)DropdownState.OK)) {
            textToDisplay = DropdownState.getMessage(dropdownState, currentOptionValue);
        } else {
            LozengeOption option = this.optionCalculator.getLozengeOption(chosenLozengeSet, optionId);
            textToDisplay = option.getName();
            color = option.getColor();
            subtle = option.getSubtle();
            textWhite = option.getTextColor();
        }
        BufferedImage image = new BufferedImage(1, 1, 1);
        int imageWidth = image.createGraphics().getFontMetrics(new Font("Monospaced", 1, 15)).stringWidth(textToDisplay) + 30;
        String url = this.createUrl(textToDisplay, color, subtle, textWhite, imageWidth);
        return new DefaultImagePlaceholder(url, false, new ImageDimensions(imageWidth, 25));
    }

    private String handleOldColors(String color) {
        switch (color) {
            case "grey": {
                return "#C0BFBC";
            }
            case "green": {
                return "#33D17A";
            }
            case "red": {
                return "#E01B24";
            }
            case "brown": {
                return "#986A44";
            }
            case "yellow": {
                return "#F6D32D";
            }
            case "blue": {
                return "#3584E4";
            }
        }
        return color;
    }

    private String createUrl(String textToDisplay, String color, boolean subtle, boolean textWhite, int imageWidth) {
        UrlBuilder urlBuilder = new UrlBuilder("/plugins/servlet/eps-easydropdownmenu/status/placeholder");
        urlBuilder.add("text", textToDisplay);
        urlBuilder.add("color", this.handleOldColors(color));
        urlBuilder.add("subtle", subtle);
        urlBuilder.add("textWhite", textWhite);
        urlBuilder.add("length", imageWidth);
        return urlBuilder.toUrl();
    }

    public String getResourcePath() {
        return "";
    }

    public void setResourcePath(String s) {
    }

    private Map<String, Object> getVelocityMap(List<LozengeOption> chosenLozengeSetList, String optionName, String currentOptionId, String color, String macroId, long pageId, boolean subtle, boolean textWhite, String dropdownClass, Boolean isSilentUpdate) {
        HashMap<String, Object> velocityMap = new HashMap<String, Object>();
        velocityMap.put("optionsList", new Gson().toJson(chosenLozengeSetList));
        velocityMap.put("optionId", currentOptionId);
        velocityMap.put("optionName", optionName);
        velocityMap.put("macroId", macroId);
        velocityMap.put("pageId", pageId);
        velocityMap.put("color", color);
        velocityMap.put("subtle", subtle);
        velocityMap.put("textWhite", textWhite);
        velocityMap.put("dropdownClass", dropdownClass);
        velocityMap.put("isSilentUpdate", isSilentUpdate);
        return velocityMap;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

