/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.macros;

import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import eps.focuspro.PermissionValidator;
import eps.focuspro.configui.PermittedGroupsCollector;
import eps.focuspro.configui.helper.ImagePlaceholderHelper;
import eps.focuspro.dropdown.dtos.DropdownDto;
import eps.focuspro.dropdown.dtos.DropdownDtoCreator;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.macros.EdmMacroUtils;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DropdownMenu
implements Macro,
EditorImagePlaceholder {
    public static final String MACRO_NAME = "easy-dropdown-menu";
    private static final String OPTIONS = "options";
    private static final String INCLUDE_BLANK = "include-blank";
    private static final String CURRENT_OPTION = "current-option";
    private static final String MULTISELECT = "multi-dropdown";
    private static final String SILENT_PAGE_UPDATE = "silent-update";
    private static final int MIN_WIDTH_SINGLE = 46;
    private static final int MIN_WIDTH_MULTI = 90;
    private static final int ADDITIONAL_WIDTH_OPTION = 16;
    private static final int ADDITIONAL_WIDTH_END_MULTI = 32;
    private static final int ADDITIONAL_WIDTH_ARROW_END_SINGLE = 41;
    private final DropdownDtoCreator dropdownDtoCreator = new DropdownDtoCreator();
    private final PermittedGroupsCollector permittedGroupsCollector;
    private final PermissionValidator permissionValidator;
    private final EdmSettingsManager edmSettingsManager;
    private final VelocityHelperService velocityHelperService;

    public DropdownMenu(PermittedGroupsCollector permittedGroupsCollector, PermissionValidator permissionValidator, EdmSettingsManager edmSettingsManager, VelocityHelperService velocityHelperService) {
        this.permittedGroupsCollector = permittedGroupsCollector;
        this.permissionValidator = permissionValidator;
        this.edmSettingsManager = edmSettingsManager;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) {
        Object dropdownClass;
        DropdownDto dropdownDto = this.dropdownDtoCreator.create(parameters, conversionContext, false);
        EdmGlobalSettings databaseSettings = this.edmSettingsManager.getGlobalSettings();
        String currentOption = parameters.get(CURRENT_OPTION) == null ? "" : parameters.get(CURRENT_OPTION);
        boolean isIncludeBlank = parameters.get(INCLUDE_BLANK) == null || parameters.get(INCLUDE_BLANK).equals("true");
        boolean isMultiSelect = Boolean.parseBoolean(parameters.get(MULTISELECT));
        boolean isSilentUpdate = Boolean.parseBoolean(parameters.get(SILENT_PAGE_UPDATE));
        List<String> combinedPermittedGroups = this.permittedGroupsCollector.collect(dropdownDto.getParameters(), dropdownDto.getSpaceKey(), databaseSettings);
        long pageId = dropdownDto.getPageId();
        boolean hasPermissionToChangeValues = this.permissionValidator.hasUserPermission(combinedPermittedGroups, pageId, databaseSettings);
        String nonPredefinedCss = databaseSettings.getDefaultNonPredefinedCssClass();
        String style = EdmMacroUtils.getCssStyle(parameters, nonPredefinedCss);
        currentOption = currentOption.replaceAll(",", ", ");
        currentOption = currentOption.replaceAll("[ ]{2,}", " ");
        Object object = dropdownClass = isMultiSelect ? "edm-dropdown-menu-non-predefined-multiple" : "edm-dropdown-menu-non-predefined";
        if (!hasPermissionToChangeValues) {
            dropdownClass = (String)dropdownClass + " edm-edit-disabled";
        }
        if (EdmMacroUtils.isLockedAndReferenced(parameters, conversionContext)) {
            dropdownClass = (String)dropdownClass + " edm-referenced-dropdown";
        }
        if (EdmMacroUtils.getBoolean(parameters, "locked-in-page-property-report", false)) {
            dropdownClass = (String)dropdownClass + " edm-lockedInPagePropertyReport-dropdown";
        }
        if (!dropdownDto.isExport()) {
            return this.velocityHelperService.getRenderedTemplate("velocity/dropdown-menu-non-predefined.vm", this.getVelocityMap(currentOption, this.getChosenTextOptions(parameters, isIncludeBlank, isMultiSelect), isIncludeBlank, dropdownDto.getMacroId(), style, (String)dropdownClass, pageId, isSilentUpdate));
        }
        return currentOption;
    }

    private String getChosenTextOptions(Map<String, String> parameters, boolean isIncludeBlank, boolean isMultiSelect) {
        String options;
        String string = options = parameters.get(OPTIONS) == null ? "Yes,No" : parameters.get(OPTIONS);
        if (isIncludeBlank && !isMultiSelect) {
            return " ," + options;
        }
        return options;
    }

    private Map<String, Object> getVelocityMap(String currentOption, String options, boolean isIncludeBlank, String macroId, String style, String dropdownClass, long pageId, boolean isSilentUpdate) {
        HashMap<String, Object> velocityMap = new HashMap<String, Object>();
        velocityMap.put("currentOption", currentOption);
        velocityMap.put(OPTIONS, options);
        velocityMap.put("isIncludeBlank", isIncludeBlank);
        velocityMap.put("pageId", pageId);
        velocityMap.put("macroId", macroId);
        velocityMap.put("style", style);
        velocityMap.put("dropdownClass", dropdownClass);
        velocityMap.put("isSilentUpdate", isSilentUpdate);
        return velocityMap;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> parameters, ConversionContext conversionContext) {
        int imageWidth;
        String textToDisplay = parameters.get(CURRENT_OPTION) == null ? "" : parameters.get(CURRENT_OPTION).replaceAll(",", "///");
        boolean isMultiSelect = Boolean.parseBoolean(parameters.get(MULTISELECT));
        BufferedImage image = new BufferedImage(1, 1, 1);
        int textPixelWidth = image.createGraphics().getFontMetrics().stringWidth(textToDisplay);
        if (isMultiSelect) {
            if (StringUtils.isEmpty((CharSequence)textToDisplay)) {
                imageWidth = 90;
            } else {
                int multiImageWidth = textPixelWidth + textToDisplay.split("///").length * 16 + 32;
                imageWidth = Math.max(multiImageWidth, 90);
            }
        } else {
            imageWidth = StringUtils.isEmpty((CharSequence)textToDisplay) ? 46 : textPixelWidth + 41;
        }
        String url = ImagePlaceholderHelper.createUrlSingleMultiPlaceholder(textToDisplay, imageWidth, false, isMultiSelect);
        return new DefaultImagePlaceholder(url, false, new ImageDimensions(imageWidth, 31));
    }
}

