/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.fix.helper;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Option;
import eps.focuspro.search.PageSearcher;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MainSetDecider {
    private final PageSearcher pageSearcher;

    public MainSetDecider(PageSearcher pageSearcher) {
        this.pageSearcher = pageSearcher;
    }

    public <T extends Option> DropdownSet<T> getMainSet(List<DropdownSet<T>> setList) {
        DropdownSet<T> decidedSet = setList.stream().max(this.getComparator()).orElse(setList.get(0));
        return this.computeNewMainSet(setList, decidedSet);
    }

    private <T extends Option> Comparator<DropdownSet<T>> getComparator() {
        return Comparator.comparing(set -> this.pageSearcher.getSearchResultCountForSetId(set.getId()));
    }

    private <T extends Option> DropdownSet<T> computeNewMainSet(List<DropdownSet<T>> list, DropdownSet<T> main) {
        String mainSetId = main.getId();
        list.removeIf(set -> set.getId().equals(mainSetId));
        for (DropdownSet<T> unusedSet : list) {
            Set<String> optionNames = this.getOptionNamesAsSet(main);
            for (Option option : unusedSet.getOptionsList()) {
                if (optionNames.contains(option.getName())) continue;
                optionNames.add(option.getName());
                main = this.updateTextDropdownSet(main, option);
            }
        }
        return main;
    }

    private <T extends Option> DropdownSet<T> updateTextDropdownSet(DropdownSet<T> main, T option) {
        List<T> options = main.getOptionsList();
        options.add(option);
        return new DropdownSet<T>(main.getId(), main.getName(), options);
    }

    private <T extends Option> Set<String> getOptionNamesAsSet(DropdownSet<T> set) {
        return set.getOptionsList().stream().map(Option::getName).collect(Collectors.toSet());
    }
}

