/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence.update;

import com.atlassian.sal.api.transaction.TransactionTemplate;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Option;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.SetHistoryAccesor;
import eps.focuspro.history.historyObjects.SetHistory;
import eps.focuspro.history.service.HistoryService;
import eps.focuspro.rest.dtos.DropdownSetComplete;
import eps.focuspro.rest.dtos.RestoreStatusOptionDto;
import eps.focuspro.rest.dtos.RestoreTextOptionDto;
import eps.focuspro.rest.helper.exceptions.DataNotFoundException;
import eps.focuspro.rest.helper.exceptions.DuplicatedDataException;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetUpdater {
    private final SetHistoryAccesor setHistoryAccesor;
    private final HistoryService<LozengeOption> statusHistoryService;
    private final HistoryService<TextOption> textHistoryService;
    private final SetEntityAccessor setEntityAccessor;
    private final TransactionTemplate transactionTemplate;
    private static final Logger log = LoggerFactory.getLogger(SetUpdater.class);

    public SetUpdater(SetHistoryAccesor setHistoryAccesor, HistoryService<LozengeOption> statusHistoryService, HistoryService<TextOption> textHistoryService, SetEntityAccessor setEntityAccessor, TransactionTemplate transactionTemplate) {
        this.setHistoryAccesor = setHistoryAccesor;
        this.statusHistoryService = statusHistoryService;
        this.textHistoryService = textHistoryService;
        this.setEntityAccessor = setEntityAccessor;
        this.transactionTemplate = transactionTemplate;
    }

    public void updateTextSet(DropdownSetComplete<TextOption> input) {
        DropdownSet<TextOption> oldDropdownSet = this.setEntityAccessor.getTextSet(input.id);
        if (oldDropdownSet == null) {
            log.error("The set you want to update doesn't exist yet");
            throw new DataNotFoundException("The set tried to update doesn't exist");
        }
        DropdownSet newDropdownSet = this.computeNewDropdownSet(input.id, input.name, (TextOption[])input.optionsList);
        SetHistory<TextOption> oldSetHistory = this.setHistoryAccesor.getTextHistoryChange(input.id);
        SetHistory<TextOption> setHistory = this.textHistoryService.createHistory(oldSetHistory, newDropdownSet, oldDropdownSet);
        this.saveTextTransactional(setHistory, newDropdownSet, input.spaceKey);
    }

    public void restoreTextOption(RestoreTextOptionDto input) {
        DropdownSet<TextOption> textSet = null;
        List<DropdownSet<TextOption>> lozengeSetsSpaceOrGlobal = this.setEntityAccessor.getTextSetsSpaceOrGlobal(input.spaceKey);
        for (DropdownSet<TextOption> lozengeOptionDropdownSet : lozengeSetsSpaceOrGlobal) {
            if (!lozengeOptionDropdownSet.getId().equals(input.setId)) continue;
            textSet = lozengeOptionDropdownSet;
        }
        if (textSet == null) {
            log.error("The DropdownSet that a Text Option should be restored didn't exist");
            throw new DataNotFoundException("The DropdownSet that a Text Option should be restored didn't exist");
        }
        List options = textSet.getOptionsList();
        if (options.stream().anyMatch(lozengeOption -> lozengeOption.getId().equals(input.optionId))) {
            log.warn("The option tried to get restored already exists in the set");
            throw new DuplicatedDataException("The option tried to get restored already exists in the set");
        }
        TextOption restoredTextOption = new TextOption(input.optionId, input.optionName);
        options.add(restoredTextOption);
        DropdownSet newDropdownSet = new DropdownSet(textSet.getId(), textSet.getName(), options);
        SetHistory<TextOption> oldSetHistory = this.setHistoryAccesor.getTextHistoryChange(input.setId);
        SetHistory<TextOption> newSetHistory = this.textHistoryService.updateSetHistoryWithRestoredItem(oldSetHistory, restoredTextOption);
        this.transactionTemplate.execute(() -> {
            this.setEntityAccessor.saveTextSetUnTransactional(newDropdownSet, input.spaceKey);
            this.setHistoryAccesor.saveTextHistoryChangeNotTransactional(newSetHistory);
            return true;
        });
    }

    public void updateStatusSet(DropdownSetComplete<LozengeOption> input) {
        DropdownSet<LozengeOption> oldLozengeSet = this.setEntityAccessor.getLozengeSet(input.id);
        if (oldLozengeSet == null) {
            log.error("The set you want to update doesn't exist yet");
            throw new DataNotFoundException("set to update wasn't found");
        }
        DropdownSet newDropdownSet = this.computeNewDropdownSet(input.id, input.name, (LozengeOption[])input.optionsList);
        SetHistory<LozengeOption> oldSetHistory = this.setHistoryAccesor.getLozengeHistoryChange(input.id);
        SetHistory<LozengeOption> setHistory = this.statusHistoryService.createHistory(oldSetHistory, newDropdownSet, oldLozengeSet);
        this.saveStatusTransactional(setHistory, newDropdownSet, input.spaceKey);
    }

    public void restoreStatusOption(RestoreStatusOptionDto input) {
        DropdownSet<LozengeOption> statusSet = null;
        List<DropdownSet<LozengeOption>> lozengeSetsSpaceOrGlobal = this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(input.spaceKey);
        for (DropdownSet<LozengeOption> lozengeOptionDropdownSet : lozengeSetsSpaceOrGlobal) {
            if (!lozengeOptionDropdownSet.getId().equals(input.setId)) continue;
            statusSet = lozengeOptionDropdownSet;
        }
        if (statusSet == null) {
            String message = "The DropdownSet that a Status Option should be restored didn't exist";
            log.error(message);
            throw new DataNotFoundException(message);
        }
        List options = statusSet.getOptionsList();
        if (options.stream().anyMatch(lozengeOption -> lozengeOption.getId().equals(input.optionId))) {
            String message = "The option tried to get restored already exists in the set";
            log.warn(message);
            throw new DuplicatedDataException(message);
        }
        LozengeOption restoredStatusOption = new LozengeOption(input.optionId, input.optionName, input.optionColor, input.optionSubtle, input.optionTextColor);
        options.add(restoredStatusOption);
        DropdownSet<LozengeOption> newDropdownSet = new DropdownSet<LozengeOption>(statusSet.getId(), statusSet.getName(), options);
        SetHistory<LozengeOption> oldSetHistory = this.setHistoryAccesor.getLozengeHistoryChange(input.setId);
        SetHistory<LozengeOption> newSetHistory = this.statusHistoryService.updateSetHistoryWithRestoredItem(oldSetHistory, restoredStatusOption);
        this.saveStatusTransactional(newSetHistory, newDropdownSet, input.spaceKey);
    }

    public String createStatusSet(String setName, @Nullable String setId, String spaceKey, List<LozengeOption> options) {
        if (StringUtils.isBlank((CharSequence)setId)) {
            setId = UUID.randomUUID().toString();
        }
        this.validateSetCreationInput(setId);
        DropdownSet<LozengeOption> dropdownSet = new DropdownSet<LozengeOption>(setId, setName, options);
        SetHistory<LozengeOption> history = this.statusHistoryService.createHistory(null, dropdownSet, null);
        this.saveStatusTransactional(history, dropdownSet, spaceKey);
        return setId;
    }

    public String createTextSet(String setName, @Nullable String setId, String spaceKey, List<TextOption> options) {
        if (StringUtils.isBlank((CharSequence)setId)) {
            setId = UUID.randomUUID().toString();
        }
        this.validateSetCreationInput(setId);
        DropdownSet<TextOption> dropdownSet = new DropdownSet<TextOption>(setId, setName, options);
        SetHistory<TextOption> history = this.textHistoryService.createHistory(null, dropdownSet, null);
        this.saveTextTransactional(history, dropdownSet, spaceKey);
        return setId;
    }

    public void deleteTextSet(String setId, String spaceKey) {
        List<DropdownSet<TextOption>> textSetsSpaceOrGlobal;
        boolean isSetPresent;
        if (spaceKey == null) {
            spaceKey = "";
        }
        if (!(isSetPresent = (textSetsSpaceOrGlobal = this.setEntityAccessor.getTextSetsSpaceOrGlobal(spaceKey)).stream().anyMatch(set -> setId.equals(set.getId())))) {
            String message = "Deletion of set with id: " + setId + " was not possible, because it couldn't be found";
            log.error(message);
            throw new DataNotFoundException(message);
        }
        this.transactionTemplate.execute(() -> {
            this.setEntityAccessor.deleteTextSetEntity(setId);
            this.setHistoryAccesor.deleteSetHistory(setId);
            return true;
        });
    }

    public void deleteStatusSet(String setId, String spaceKey) {
        List<DropdownSet<LozengeOption>> lozengeSetsSpaceOrGlobal;
        boolean isPresent;
        if (spaceKey == null) {
            spaceKey = "";
        }
        if (!(isPresent = (lozengeSetsSpaceOrGlobal = this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(spaceKey)).stream().anyMatch(set -> setId.equals(set.getId())))) {
            String message = "Deletion of set with id: " + setId + " was not possible, because it couldn't be found";
            log.error(message);
            throw new DataNotFoundException(message);
        }
        this.transactionTemplate.execute(() -> {
            this.setEntityAccessor.deleteLozengeSetEntity(setId);
            this.setHistoryAccesor.deleteSetHistory(setId);
            return true;
        });
    }

    private void saveStatusTransactional(SetHistory<LozengeOption> setHistory, DropdownSet<LozengeOption> newDropdownSet, String spaceKey) {
        if (setHistory != null && newDropdownSet != null) {
            this.transactionTemplate.execute(() -> {
                this.setHistoryAccesor.saveLozengeHistoryChangeNotTransactional(setHistory);
                this.setEntityAccessor.saveLozengeSetUnTransactional(newDropdownSet, spaceKey);
                return true;
            });
        } else if (setHistory == null && newDropdownSet != null) {
            this.transactionTemplate.execute(() -> {
                this.setEntityAccessor.saveLozengeSetUnTransactional(newDropdownSet, spaceKey);
                return true;
            });
        } else {
            throw new RuntimeException("There was an unexpected error causing the status set to not get saved");
        }
    }

    private void saveTextTransactional(SetHistory<TextOption> setHistory, DropdownSet<TextOption> newDropdownSet, String spaceKey) {
        if (setHistory != null && newDropdownSet != null) {
            this.transactionTemplate.execute(() -> {
                this.setHistoryAccesor.saveTextHistoryChangeNotTransactional(setHistory);
                this.setEntityAccessor.saveTextSetUnTransactional(newDropdownSet, spaceKey);
                return true;
            });
        } else if (setHistory == null && newDropdownSet != null) {
            this.transactionTemplate.execute(() -> {
                this.setEntityAccessor.saveTextSetUnTransactional(newDropdownSet, spaceKey);
                return true;
            });
        } else {
            throw new RuntimeException("There was an unexpected error causing the status set to not get saved");
        }
    }

    private <T extends Option> DropdownSet<T> computeNewDropdownSet(String id, String name, T[] optionArray) {
        ArrayList<T> optionsList = new ArrayList<T>(Arrays.asList(optionArray));
        return new DropdownSet<T>(id, name, optionsList);
    }

    private void validateSetCreationInput(String setId) {
        if (this.idExists(setId)) {
            String message = "The setId trying to create a new set with does already exist";
            log.error(message);
            throw new DuplicatedDataException(message);
        }
    }

    private boolean idExists(String setId) {
        DropdownSet<TextOption> textSet = this.setEntityAccessor.getTextSet(setId);
        DropdownSet<LozengeOption> lozengeSet = this.setEntityAccessor.getLozengeSet(setId);
        return lozengeSet != null || textSet != null;
    }
}

