/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence.config.daos;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSpaceSettings;
import eps.focuspro.edm.persistence.entities.CssClass;
import eps.focuspro.edm.persistence.entities.EdmConfig;
import eps.focuspro.edm.persistence.entities.PermittedGroup;
import eps.focuspro.edm.persistence.update.SetUpdater;
import eps.focuspro.rest.dtos.DropdownSetComplete;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdmConfigDao {
    private final ActiveObjects ao;
    private static final Logger log = LoggerFactory.getLogger(EdmConfigDao.class);
    private final TransactionTemplate transactionTemplate;
    private final SetUpdater setUpdater;

    public EdmConfigDao(ActiveObjects ao, TransactionTemplate transactionTemplate, SetUpdater setUpdater) {
        this.ao = Objects.requireNonNull(ao);
        this.transactionTemplate = transactionTemplate;
        this.setUpdater = setUpdater;
    }

    public EdmGlobalSettings getGlobalSettings() {
        return (EdmGlobalSettings)this.transactionTemplate.execute(() -> {
            EdmConfig globalEntity = this.getConfigAndAssureConsistency(null);
            return this.mapGlobalSettings(globalEntity);
        });
    }

    public EdmSpaceSettings getSpaceSettings(String spaceKey) {
        return (EdmSpaceSettings)this.transactionTemplate.execute(() -> {
            EdmConfig edmConfig = this.getConfigAndAssureConsistency(spaceKey);
            return this.mapSpaceSettings(edmConfig);
        });
    }

    public void saveGlobalSettings(EdmGlobalSettings edmGlobalSettings) {
        this.transactionTemplate.execute(() -> {
            EdmConfig edmConfig = this.getConfigAndAssureConsistency(null);
            this.saveGlobalConfigInternal(edmConfig, edmGlobalSettings);
            return null;
        });
    }

    public void saveSpaceSettings(EdmSpaceSettings edmSpaceSettings) {
        this.transactionTemplate.execute(() -> {
            EdmConfig edmConfig = this.getConfigAndAssureConsistency(edmSpaceSettings.getSpaceKey());
            this.saveSpaceConfigInternal(edmConfig, edmSpaceSettings);
            return null;
        });
    }

    private EdmConfig getConfigAndAssureConsistency(String spaceKey) {
        EdmConfig[] edmConfigs = this.getConfigs(spaceKey);
        this.removeDuplicatedConfigEntries(edmConfigs, spaceKey);
        if (edmConfigs.length == 0) {
            if (spaceKey == null) {
                return this.recoverGlobalSettings();
            }
            return this.recoverSpaceSettings(spaceKey);
        }
        return edmConfigs[0];
    }

    private EdmConfig[] getConfigs(String spaceKey) {
        if (spaceKey == null) {
            return (EdmConfig[])this.ao.find(EdmConfig.class, Query.select().where("SPACE_KEY IS NULL or SPACE_KEY = ?", new Object[]{""}));
        }
        return (EdmConfig[])this.ao.find(EdmConfig.class, Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey}));
    }

    private EdmConfig recoverGlobalSettings() {
        EdmGlobalSettings globalSettings = new EdmGlobalSettings("", "", "", true, false, false, Collections.emptyList(), Collections.emptyList());
        this.getDefaultLozengeSets().forEach(set -> this.setUpdater.createStatusSet(set.name, set.id, set.spaceKey, Arrays.stream((LozengeOption[])set.optionsList).toList()));
        this.getDefaultTextSets().forEach(set -> this.setUpdater.createTextSet(set.name, set.id, set.spaceKey, Arrays.stream((TextOption[])set.optionsList).toList()));
        return this.saveGlobalConfigInternal((EdmConfig)this.ao.create(EdmConfig.class, new DBParam[0]), globalSettings);
    }

    private List<DropdownSetComplete<TextOption>> getDefaultTextSets() {
        return List.of(this.createTextSet("Months", List.of("January", "February", "March", "April", "May", "June", "July", "August", "September", "November", "December")), this.createTextSet("Contacts", List.of("CEO (Chief Executive Officer)", "CFO (Chief Financial Officer)", "CMO (Chief Marketing Officer)", "COO (Chief Operation Officer)", "CTO (Chief Technical Officer)", "Part-Time-Employee", "Full-Time-Employee", "Trainee")), this.createTextSet("File extensions", List.of(".doc", ".pdf", ".txt", ".jpg", ".gif", ".mp3", ".html", ".exe")), this.createTextSet("Weekdays", List.of("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday")));
    }

    private DropdownSetComplete<TextOption> createTextSet(String name, List<String> values) {
        TextOption[] options = (TextOption[])values.stream().map(label -> new TextOption(UUID.randomUUID().toString(), (String)label)).toArray(TextOption[]::new);
        return new DropdownSetComplete<TextOption>(UUID.randomUUID().toString(), name, "", options);
    }

    private List<DropdownSetComplete<LozengeOption>> getDefaultLozengeSets() {
        return List.of(this.createLozengeSet("Traffic light", Map.of("Stop", "#E01B24", "Go if possible", "#F6D32D", "Go!", "#33D17A")), this.createLozengeSet("Default", Map.of("SUCCESS", "#33D17A", "COMPLETE", "#3584E4", "CURRENT", "#F6D32D", "ERROR", "#E01B24", "MOVED", "#986A44", "GENERIC", "#C0BFBC")), this.createLozengeSet("Email Status", Map.of("Waiting for E-Mail", "#33D17A", "Reply to E-Mail", "#3584E4", "E-Mail sent", "#F6D32D", "Created draft E-Mail", "#E01B24", "E-Mail deleted", "#986A44", "Junk E-Mail", "#C0BFBC")), this.createLozengeSet("Ticket Status", Map.of("Waiting for Customer", "#33D17A", "In progress", "#3584E4", "Investigating", "#F6D32D", "Escalated", "#E01B24", "Canceled", "#986A44", "Resolved", "#C0BFBC")), this.createLozengeSet("Active Sprint Status", Map.of("Ready", "#33D17A", "Postponed", "#3584E4", "In progress", "#F6D32D", "Review", "#E01B24", "Done", "#986A44")));
    }

    private DropdownSetComplete<LozengeOption> createLozengeSet(String name, Map<String, String> colorMap) {
        return new DropdownSetComplete<LozengeOption>(UUID.randomUUID().toString(), name, "", this.generateSetOptions(colorMap));
    }

    private LozengeOption[] generateSetOptions(Map<String, String> options) {
        return (LozengeOption[])options.entrySet().stream().map(entry -> new LozengeOption(UUID.randomUUID().toString(), (String)entry.getKey(), (String)entry.getValue(), false, false)).toArray(LozengeOption[]::new);
    }

    private EdmConfig recoverSpaceSettings(String spaceKey) {
        EdmSpaceSettings spaceSettings = new EdmSpaceSettings(spaceKey, Collections.emptyList(), Collections.emptyList());
        return this.saveSpaceConfigInternal((EdmConfig)this.ao.create(EdmConfig.class, new DBParam[0]), spaceSettings);
    }

    private void removeDuplicatedConfigEntries(EdmConfig[] edmConfigs, String spaceKey) {
        if (edmConfigs.length > 1) {
            log.warn("Duplicated config found for space: '{}' (null = global) -> deleting duplicated entries", (Object)spaceKey);
            for (int i = 1; i < edmConfigs.length; ++i) {
                EdmConfig edmConfig = edmConfigs[i];
                this.deleteEdmConfig(edmConfig);
            }
        }
    }

    private EdmGlobalSettings mapGlobalSettings(EdmConfig edmConfig) {
        return new EdmGlobalSettings(edmConfig.getDefaultEditModeCssClass(), edmConfig.getDefNonPredefCssClass(), edmConfig.getDefaultPredefinedCssClass(), edmConfig.getIsSuppressNotifications(), edmConfig.getAllowAnon(), edmConfig.getAllowWithoutEditPermission(), this.sanitizedList(edmConfig.getCssClassArray(), CssClass::getCssClassValue), this.sanitizedList(edmConfig.getPermittedGroupArray(), PermittedGroup::getPermittedGroupValue));
    }

    private EdmSpaceSettings mapSpaceSettings(EdmConfig edmConfig) {
        return new EdmSpaceSettings(edmConfig.getSpaceKey(), this.sanitizedList(edmConfig.getCssClassArray(), CssClass::getCssClassValue), this.sanitizedList(edmConfig.getPermittedGroupArray(), PermittedGroup::getPermittedGroupValue));
    }

    private <T> List<String> sanitizedList(T[] entities, Function<T, String> extractor) {
        return Arrays.stream(entities).map(extractor).map(value -> value == null ? "" : value).collect(Collectors.toList());
    }

    private void deleteEdmConfig(EdmConfig edmConfig) {
        for (CssClass cssClass : edmConfig.getCssClassArray()) {
            this.ao.delete(new RawEntity[]{this.ao.get(CssClass.class, (Object)cssClass.getID())});
        }
        for (PermittedGroup permittedGroup : edmConfig.getPermittedGroupArray()) {
            this.ao.delete(new RawEntity[]{this.ao.get(PermittedGroup.class, (Object)permittedGroup.getID())});
        }
        this.ao.delete(new RawEntity[]{this.ao.get(EdmConfig.class, (Object)edmConfig.getID())});
    }

    private EdmConfig saveGlobalConfigInternal(EdmConfig edmConfig, EdmGlobalSettings settings) {
        this.saveCssClasses(edmConfig, settings.getCssClasses());
        this.savePermittedGroups(edmConfig, settings.getPermittedGroups());
        edmConfig.setSpaceKey("");
        edmConfig.setDefaultEditModeCssClass(settings.getDefaultEditModeCssClass());
        edmConfig.setDefNonPredefCssClass(settings.getDefaultNonPredefinedCssClass());
        edmConfig.setDefaultPredefinedCssClass(settings.getDefaultPredefinedCssClass());
        edmConfig.setIsSuppressNotifications(settings.isSuppressNotifications());
        edmConfig.setAllowAnon(settings.isAllowAnonymous());
        edmConfig.setAllowWithoutEditPermission(settings.isAllowWithoutEditPermission());
        edmConfig.save();
        return edmConfig;
    }

    private EdmConfig saveSpaceConfigInternal(EdmConfig edmConfig, EdmSpaceSettings settings) {
        this.saveCssClasses(edmConfig, settings.getCssClasses());
        this.savePermittedGroups(edmConfig, settings.getPermittedGroups());
        edmConfig.setSpaceKey(settings.getSpaceKey());
        edmConfig.save();
        return edmConfig;
    }

    private void saveCssClasses(EdmConfig edmConfig, List<String> classNames) {
        Entity[] persistedClasses = edmConfig.getCssClassArray();
        this.updateFields(persistedClasses, classNames, CssClass::getCssClassValue, value -> this.addCssClass(edmConfig, (String)value));
    }

    private void savePermittedGroups(EdmConfig edmConfig, List<String> permittedGroupNames) {
        Entity[] persistedGroups = edmConfig.getPermittedGroupArray();
        this.updateFields(persistedGroups, permittedGroupNames, PermittedGroup::getPermittedGroupValue, value -> this.addPermittedGroup(edmConfig, (String)value));
    }

    private <T extends Entity> void updateFields(T[] persistedFields, List<String> newValues, Function<T, String> extractor, Consumer<String> creator) {
        List persistedValues = Arrays.stream(persistedFields).map(extractor).collect(Collectors.toList());
        for (String newValue : newValues) {
            if (persistedValues.contains(newValue)) continue;
            creator.accept(newValue);
        }
        for (T entity : persistedFields) {
            if (newValues.contains(extractor.apply(entity))) continue;
            this.ao.delete(new RawEntity[]{entity});
        }
    }

    private void addPermittedGroup(EdmConfig edmConfig, String groupName) {
        PermittedGroup permittedGroup = (PermittedGroup)this.ao.create(PermittedGroup.class, new DBParam[0]);
        permittedGroup.setEdmConfig(edmConfig);
        permittedGroup.setPermittedGroupValue(groupName);
        permittedGroup.save();
    }

    private void addCssClass(EdmConfig edmConfig, String className) {
        CssClass toAdd = (CssClass)this.ao.create(CssClass.class, new DBParam[0]);
        toAdd.setCssClassValue(className);
        toAdd.setEdmConfig(edmConfig);
        toAdd.save();
    }

    private EdmGlobalSettings getDefaultGlobalSettings() {
        return new EdmGlobalSettings("", "", "", false, false, false, Collections.emptyList(), Collections.emptyList());
    }
}

