/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.entities.TextOptionEntity;
import eps.focuspro.edm.persistence.entities.TextSetEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.DBParam;

public class TextEntityConverter {
    public DropdownSet<TextOption> convertFromEntity(TextSetEntity entity) {
        if (entity == null) {
            return null;
        }
        return this.createDropdownSet(entity);
    }

    public TextOptionEntity[] convertToEntity(List<TextOption> optionList, TextSetEntity textSetEntity, ActiveObjects ao) {
        return (TextOptionEntity[])optionList.stream().map(option -> this.setUpOptionEntity((TextOption)option, textSetEntity, ao)).toArray(TextOptionEntity[]::new);
    }

    private DropdownSet<TextOption> createDropdownSet(TextSetEntity entity) {
        return new DropdownSet<TextOption>(entity.getSetId(), entity.getSetName(), this.convertFromEntity(entity.getOptionsArray()));
    }

    private ArrayList<TextOption> convertFromEntity(TextOptionEntity[] entityArray) {
        if (entityArray == null) {
            return new ArrayList<TextOption>();
        }
        return Arrays.stream(entityArray).map(entity -> new TextOption(entity.getOptionId(), entity.getOptionName())).collect(Collectors.toCollection(ArrayList::new));
    }

    private TextOptionEntity setUpOptionEntity(TextOption option, TextSetEntity textSetEntity, ActiveObjects ao) {
        TextOptionEntity textOptionEntity = (TextOptionEntity)ao.create(TextOptionEntity.class, new DBParam[0]);
        textOptionEntity.setOptionId(option.getId());
        textOptionEntity.setOptionName(option.getName());
        textOptionEntity.setTextSetEntity(textSetEntity);
        return textOptionEntity;
    }
}

