/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui.spaceconfig;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.edm.persistence.config.EdmSpaceSettings;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceConfigAction
extends SpaceAdminAction {
    private final transient SoyTemplateRenderer soyRenderer;
    private transient List<DropdownSet<LozengeOption>> lozengeSets;
    private List<String> groups;
    private transient List<DropdownSet<TextOption>> textSets;
    private List<String> cssClasses;
    private final transient SetEntityAccessor setEntityAccessor;
    private final transient EdmSettingsManager edmSettingsManager;
    private final AccessModeService accessModeService;
    private boolean isReadOnlyModeActive;
    private final SettingsManager settingsManager;
    private String baseUrl;
    private static final String SPACE_KEY = "spaceKey";
    private static final Logger log = LoggerFactory.getLogger(SpaceConfigAction.class);

    public SpaceConfigAction(SoyTemplateRenderer soyTemplateRenderer, SetEntityAccessor setEntityAccessor, EdmSettingsManager edmSettingsManager, AccessModeService accessModeService, SettingsManager settingsManager) {
        this.soyRenderer = soyTemplateRenderer;
        this.setEntityAccessor = setEntityAccessor;
        this.edmSettingsManager = edmSettingsManager;
        this.accessModeService = accessModeService;
        this.settingsManager = settingsManager;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        HttpServletRequest request = this.getActiveRequest();
        String spaceKey = Optional.of(request.getParameter(SPACE_KEY)).orElse("none");
        EdmSpaceSettings spaceSettings = this.edmSettingsManager.getSpaceSettings(spaceKey);
        this.cssClasses = spaceSettings.getCssClasses();
        this.lozengeSets = this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(spaceKey) == null ? new ArrayList() : this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(spaceKey);
        this.groups = spaceSettings.getPermittedGroups();
        this.textSets = this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(spaceKey) == null ? new ArrayList() : this.setEntityAccessor.getTextSetsSpaceOrGlobal(spaceKey);
        this.isReadOnlyModeActive = this.accessModeService.isReadOnlyAccessModeEnabled();
        this.baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        return "input";
    }

    public String doDefault() {
        return "input";
    }

    public List<DropdownSet<LozengeOption>> getLozengeSets() {
        return this.lozengeSets;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<DropdownSet<TextOption>> getTextSets() {
        return this.textSets;
    }

    public SoyTemplateRenderer getSoyRenderer() {
        return this.soyRenderer;
    }

    public List<String> getCssClasses() {
        return this.cssClasses;
    }

    public boolean getIsReadOnlyModeActive() {
        return this.isReadOnlyModeActive;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

