/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui;

import eps.focuspro.configui.helper.ImagePlaceholderHelper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePlaceholderSingleGenerator
extends HttpServlet {
    private static final int imageHeight = 31;
    private static final Color TEXT_COLOR = new Color(23, 43, 77);
    private static final Color BACKGROUND_COLOR = new Color(234, 235, 237);
    private static final Logger log = LoggerFactory.getLogger(ImagePlaceholderSingleGenerator.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String text = req.getParameter("text");
        int imageWidth = Integer.parseInt(req.getParameter("length"));
        boolean isStateMessage = Boolean.parseBoolean(req.getParameter("isStateMessage"));
        BufferedImage image = new BufferedImage(imageWidth, 31, 1);
        Graphics2D graphics2D = image.createGraphics();
        ImagePlaceholderHelper.setBackground(imageWidth, 31, BACKGROUND_COLOR, image, graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ImagePlaceholderHelper.drawText(graphics2D, text, graphics2D.getFont(), TEXT_COLOR, 10, 20);
        if (!isStateMessage) {
            graphics2D.fillPolygon(new int[]{imageWidth - 16, imageWidth - 13, imageWidth - 10, imageWidth - 16}, new int[]{13, 16, 13, 13}, 4);
        }
        resp.setContentType("image/png");
        try {
            ImageIO.write((RenderedImage)image, "png", (OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            log.error("Error on EditorPlaceholder", (Throwable)e);
        }
    }
}

