/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.gson.Gson;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Option;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.rest.helper.DataMigrationHandler;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigServlet
extends HttpServlet {
    private static final String EDM_CONFIG_SERVLET_TEMPLATE = "Confluence.Sap.Configure.doGet";
    private final LoginUriProvider loginUriProvider;
    private final UserManager userManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final SetEntityAccessor setEntityAccessor;
    private final EdmSettingsManager edmSettingsManager;
    private static final Logger log = LoggerFactory.getLogger(ConfigServlet.class);
    private final AccessModeService accessModeService;
    private final DataMigrationHandler dataMigrationHandler;

    ConfigServlet(UserManager userManager, LoginUriProvider loginUriProvider, SoyTemplateRenderer soyTemplateRenderer, SetEntityAccessor setEntityAccessor, EdmSettingsManager edmSettingsManager, AccessModeService accessModeService, DataMigrationHandler dataMigrationHandler) {
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.setEntityAccessor = setEntityAccessor;
        this.edmSettingsManager = edmSettingsManager;
        this.accessModeService = accessModeService;
        this.dataMigrationHandler = dataMigrationHandler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        EdmGlobalSettings dbSettings = this.edmSettingsManager.getGlobalSettings();
        try {
            this.enforcePermissions(req, resp);
        }
        catch (Exception e) {
            log.warn("Error enforcing Permissions", (Throwable)e);
        }
        resp.setContentType("text/html;charset=UTF-8");
        List<DropdownSet<TextOption>> textDropdownSets = this.setEntityAccessor.getTextSetsSpaceOrGlobal("");
        List<DropdownSet<LozengeOption>> statusDropdownSets = this.setEntityAccessor.getLozengeSetsSpaceOrGlobal("");
        List<String> permittedGroups = dbSettings.getPermittedGroups();
        List<String> cssClasses = dbSettings.getCssClasses();
        textDropdownSets.sort(this.getComparator());
        statusDropdownSets.sort(this.getComparator());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("context_path", req.getContextPath());
        context.put("spaces", new Gson().toJson(this.dataMigrationHandler.getSpaceDtoList()));
        context.put("css_classes", cssClasses);
        context.put("edm_suppress_notifications", dbSettings.isSuppressNotifications());
        context.put("edm_allow_anonymous", dbSettings.isAllowAnonymous());
        context.put("edm_allow_without_edit_permissions", dbSettings.isAllowWithoutEditPermission());
        context.put("dropdown_groups", permittedGroups);
        context.put("lozenge_sets", statusDropdownSets);
        context.put("text_sets", textDropdownSets);
        context.put("defaultPredefinedCss", dbSettings.getDefaultPredefinedCssClass());
        context.put("defaultNonPredifinedCss", dbSettings.getDefaultNonPredefinedCssClass());
        context.put("defaultEditModeCss", dbSettings.getDefaultEditModeCssClass());
        context.put("readOnlyModeActive", this.accessModeService.isReadOnlyAccessModeEnabled() ? "disabled" : "");
        this.render(resp, context);
    }

    private void render(HttpServletResponse resp, Map<String, Object> data) {
        String webResource = "eps.focuspro.EasyDropdownMenu:easy-dropdown-menu-configure-v6.1.0";
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), webResource, EDM_CONFIG_SERVLET_TEMPLATE, data);
        }
        catch (Exception e) {
            log.error("Error in Task Servlet", (Throwable)e);
        }
    }

    private void enforcePermissions(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        UserKey userKey = this.userManager.getRemoteUserKey(req);
        if (userKey == null) {
            resp.sendRedirect(this.loginUriProvider.getLoginUri(URI.create(req.getRequestURL().toString())).toASCIIString());
        } else if (!this.userManager.isAdmin(userKey)) {
            resp.sendError(404);
        }
    }

    private <T extends Option> Comparator<DropdownSet<T>> getComparator() {
        return Comparator.comparing(DropdownSet::getName);
    }
}

