/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.Entity;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.rest.helper.exceptions.DataNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionValidator {
    private final PermissionManager permissionManager;
    private final PageManager pageManager;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final SpaceManager spaceManager;
    private static final Logger log = LoggerFactory.getLogger(PermissionValidator.class);

    public PermissionValidator(PermissionManager permissionManager, PageManager pageManager, UserManager userManager, GroupManager groupManager, SpaceManager spaceManager) {
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.spaceManager = spaceManager;
    }

    public boolean isEditingAllowed(long pageId, EdmGlobalSettings databaseSettings) {
        return this.isNotAnonymousOrAllowed(databaseSettings.isAllowAnonymous()) && pageId > 0L && this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), databaseSettings.isAllowWithoutEditPermission() ? Permission.VIEW : Permission.EDIT, (Object)this.pageManager.getAbstractPage(pageId));
    }

    public boolean isNotAnonymousOrAllowed(boolean isAllowAnonymous) {
        return !AuthenticatedUserThreadLocal.isAnonymousUser() || isAllowAnonymous;
    }

    public boolean isCurrentUserAdmin() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.isSystemAdministrator(user) || this.permissionManager.isConfluenceAdministrator(user);
    }

    public boolean isCurrentUserSpaceAdmin(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            String message = "Space could not be found";
            log.error(message);
            throw new DataNotFoundException(message);
        }
        return this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)space);
    }

    private UserKey getUserKey() {
        return this.userManager.getRemoteUserKey();
    }

    public List<Group> getAllGroups() {
        return this.groupManager.getWritableGroups();
    }

    public List<String> getGroupNamesFromGroups(List<Group> uiGroups) {
        return Optional.ofNullable(uiGroups).orElse(Collections.emptyList()).stream().map(Entity::getName).toList();
    }

    public boolean hasUserPermission(List<String> groupNames, long pageId, EdmGlobalSettings databaseSettings) {
        boolean isEditingAllowed = this.isEditingAllowed(pageId, databaseSettings);
        if (groupNames.isEmpty() && isEditingAllowed) {
            return true;
        }
        return isEditingAllowed && this.isUserInAllowedGroup(groupNames);
    }

    private boolean isUserInAllowedGroup(List<String> groupNames) {
        UserKey userKey = this.getUserKey();
        return groupNames.stream().anyMatch(group -> this.userManager.isUserInGroup(userKey, group));
    }
}

