export const convertToUniversalSetSelectObject = function (valueArray) {
    const groups = [];
    for (let i = 0, length = valueArray.length; i < length; i++) {
        if (typeof valueArray[i]["id"] === "string") {
            groups.push({id: valueArray[i]["id"], text: valueArray[i]["name"]});
        }
    }
    return groups;
};

const getOldColors = function (optionColor) {
        switch (optionColor) {
            case 'grey':
                return '#C0BFBC';
            case 'green':
                return '#33D17A';
            case 'red':
                return '#E01B24';
            case 'brown':
                return '#986A44';
            case 'yellow':
                return '#F6D32D';
            case 'blue':
                return '#3584E4';
            default:
                return optionColor;
        }
};

export const convertToStatusSelectObject = function (valueList) {
    return valueList.map(option => {
        let styleClass = 'status-general-styles';
        let dynamicStylesSubtleAndText = '';

        if (option.subtle) {
            dynamicStylesSubtleAndText = `color: ${getOldColors(option.color)}; border-color: ${getOldColors(option.color)};`;
            styleClass += ' subtle';
        } else if (option.textColor) {
            dynamicStylesSubtleAndText = `background-color: ${getOldColors(option.color)}; border-color: ${getOldColors(option.color)};`;
            styleClass += ' textColor';
        } else {
            dynamicStylesSubtleAndText = `background-color: ${getOldColors(option.color)}; border-color: ${getOldColors(option.color)};`;
        }

        const text = `<span class="aui-lozenge ${styleClass}" style="${dynamicStylesSubtleAndText}">${option.name}</span>`;
        return { id: option.id, text: text };
    });
};


export const convertToTextOptionSelectObject = function (valueList) {
    const groups = [];
    valueList.forEach(function (option) {
        groups.push({id: option.id, text: option.name});
    });
    return groups;
};

export const getCurrentOptionsArrayFromResp = function (input, resp) {
    const optionIds = input.val();
    input.val(null).trigger("change");
    if (optionIds) {
        return optionIds.split(",").map(optionId => resp.find(option => option.id === optionId) || {id: optionId, name: "OptionNotFound"});
    }
    return [];
};

export const templateGet = function (data) {
    return data.text;
};

export const convertToSelectObject = function (valueArray) {
    const groups = [];
    for (let i = 0, length = valueArray.length; i < length; i++) {
        if (typeof valueArray[i] === "string") {
            groups.push({id: valueArray[i], text: valueArray[i]});
        }
    }
    return groups;
};

export const changeLinkToSpan = function (entry) {
    const aElement = AJS.$("a", entry).first();
    const spanElement = document.createElement("span");
    spanElement.setAttribute("class", aElement.attr("class"));
    spanElement.setAttribute("tabindex", "-1");
    copyEventHandlers(aElement, spanElement);
    entry.replaceChild(spanElement, aElement.get(0));
};

const copyEventHandlers = function (oldElement, newElement) {
    AJS.$.each(AJS.$._data(AJS.$(oldElement).get(0), "events"), function () {
        AJS.$.each(this, function () {
            AJS.$(newElement).bind(this.type, this.handler);
        });
    });
};

export const unwrapDiv = function (entry) {
    const divElement = AJS.$("div", entry).first();
    const innerHtmlDiv = divElement.html();
    if (typeof innerHtmlDiv !== "undefined") {
        const innerHtmlNode = document.createTextNode(innerHtmlDiv);
        entry.replaceChild(innerHtmlNode, divElement.get(0));
    }
};


