import {showRememberToSaveCss} from "./edm-universal-config";

const createWarningDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-delete-warning-config\" class=\"aui-dialog2 aui-dialog2-medium aui-layer\" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-delete-warning-config").length === 0) {
        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }

        AJS.dialog2("#edm-delete-warning-config").on("hide", function () {
            AJS.$("#edm-delete-warning-config").html("");
        });
    }
};

//----------------------Editor-Div-Creator-------------------------------------------------------------------------------
const createUniversalStatusDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-status-dialog-config\" class=\"aui-layer aui-dialog2 \" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-status-dialog-config").length === 0) {

        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }
        AJS.dialog2("#edm-status-dialog-config").on("hide", function () {
            AJS.$("#edm-status-dialog-config").html("");
        });
    }
};

const createUniversalHistoryDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-history-dialog\" class=\"aui-layer aui-dialog2 \" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-history-dialog").length === 0) {

        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }
        AJS.dialog2("#edm-history-dialog").on("hide", function () {
            AJS.$("#edm-history-dialog").html("");
        });
    }
};

const createUniversalMacroUsageDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-macro-usage-dialog\" class=\"aui-layer aui-dialog2 \" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-macro-usage-dialog").length === 0) {

        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }
        AJS.dialog2("#edm-macro-usage-dialog").on("hide", function () {
            AJS.$("#edm-macro-usage-dialog").html("");
        });
    }
};

const createUniversalTextDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-text-dialog-config\" class=\"aui-layer aui-dialog2 \" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-text-dialog-config").length === 0) {
        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }
        AJS.dialog2("#edm-text-dialog-config").on("hide", function () {
            AJS.$("#edm-text-dialog-config").html("");
        });
    }
};

export const createUniversalDataMigrationDialogDivIfNeeded = function () {
    const dialogHtmlOut = "<section role=\"dialog\" id=\"edm-data-migration-dialog\" class=\"aui-layer aui-dialog2 \" aria-hidden=\"true\"></section>";
    if (AJS.$("#edm-data-migration-dialog").length === 0) {

        if ($('#admin-content').length) {
            AJS.$(dialogHtmlOut).insertAfter('#admin-content');
        } else {
            AJS.$(dialogHtmlOut).insertAfter('#content');
        }
        AJS.dialog2("#edm-data-migration-dialog").on("hide", function () {
            AJS.$("#edm-data-migration-dialog").html("");
        });
    }
};

//---------------------------------check if new SetNameValid----------------------------------------------------------------------------
export const checkIfSetNameValid = function (newSetName, elements) {
    let valid = true;
    if (!newSetName.length >= 1) {
        valid = false;
    }
    $(elements).each(function (index, element) {
        if ($(element).text() === newSetName) {
            valid = false;
        }
    });
    return valid;
};

//----------------------------------------------------------------------------
export const getDataMigrationDialogHtml = function (isReadOnlyModeActive, allSpaces) {
    return Confluence.Sap.Configure.DataMigration.Dialog.doGet({
        isReadOnlyModeActive: isReadOnlyModeActive,
        auiVersion: parseInt(AJS.version),
        spaces: allSpaces
    });
};

export const getCssDefaults = function () {
    const map = {};
    map["editMode"] = AJS.$('#edm-css-editMode').val();
    map["non-predefined"] = AJS.$('#edm-css-non-predefined').val();
    map["predefined"] = AJS.$('#edm-css-predefined').val();
    return map;
};

export const getCssClasses = function () {
    const classes = [];
    AJS.$('.css-class').each(function () {
        const css = this.textContent;
        classes.push(css);
    });
    return classes;
};

export const succesInsertCssHtml = function (htmlString) {
    AJS.$('#cssHtmlToReplace').replaceWith(htmlString);
    showRememberToSaveCss(AJS.$('#edm-css-save-reminder'));
};

export const getGroupNames = function () {
    const groups = [];
    AJS.$('.group-name').each(function () {
        const group = this.textContent;
        groups.push(group);
    });
    return groups;
};

// ----------------GET-THEM-BOOLEANS-FROM-CHECKBOXES------------------------
export const getSuppressNotifications = function () {
    return AJS.$('#edm-suppress-notifications').is(':checked');
};

export const getEdmAllowAnonymous = function () {
    return AJS.$('#edm-allow-anonymous').is(':checked');
};

export const getEdmAllowWithoutEditPermission = function () {
    return AJS.$('#edm-allow-without-edit-permissions').is(':checked');
};

// ----------------GET-EDIT-MODE-TEXT_NO_VALUE------------------------
export const getEditModeTextNoValue = function () {
    return AJS.$('#edm-edit-mode-text-no-value').val();
};

const getDeleteWarningHtml = function (setId, buttonId, setName) {
    return Confluence.Sap.Configure.Lozenge.deleteWarning({
        set_id: setId,
        button_id: buttonId,
        auiVersion: parseInt(AJS.version),
        setName: setName,
    });
};

export const handleNewInputsInStatusSetEditor = function (subtleCheckbox, inputField, chosenColorFromPicker, textWhiteCheckbox) {

    if (subtleCheckbox.is(":checked")) {
        inputField.css('background', 'white');
        inputField.css('color', chosenColorFromPicker);
        inputField.css('borderColor', chosenColorFromPicker);
    } else if (textWhiteCheckbox.is(":checked")) {
        inputField.css('background', chosenColorFromPicker);
        inputField.css('color', 'white');
        inputField.css('borderColor', chosenColorFromPicker);
    } else {
        inputField.css('background', chosenColorFromPicker);
        inputField.css('color', 'black');
        inputField.css('borderColor', chosenColorFromPicker);
    }
}

export const resizable = function (el, factor) {
    const int = Number(factor) || 7.7;

    function resize() {
        el.style.width = ((el.value.length + 1) * int) + 'px'
    }

    const e = 'keyup,keypress,focus,blur,change'.split(',');
    for (let i in e) el.addEventListener(e[i], resize, false);
    resize();
};

export const createStatusTemplateWindow = function (dropdownSet, isReadOnlyModeActive, htmlGetterFunction) {
    createUniversalStatusDialogDivIfNeeded();
    const htmlString = htmlGetterFunction(dropdownSet, isReadOnlyModeActive);
    AJS.$("#edm-status-dialog-config").html(htmlString);
    AJS.dialog2("#edm-status-dialog-config").show();
    AJS.$('.edm-option-field-input').each(function () {
        resizable(this, 7);
    });
    if (!isReadOnlyModeActive) {
        AJS.$('.edm-set-editor-list').sortable();
    }
};

export const createHistoryWindow = function (statusHistory, htmlFunction) {
    createUniversalHistoryDialogDivIfNeeded();
    const htmlString = htmlFunction(statusHistory);
    AJS.$("#edm-history-dialog").html(htmlString);
    AJS.dialog2("#edm-history-dialog").show();
};

export const createUsageWindow = function (htmlString) {
    createUniversalMacroUsageDialogDivIfNeeded();
    AJS.$("#edm-macro-usage-dialog").html(htmlString);
    AJS.dialog2("#edm-macro-usage-dialog").show();
};

export const createTextTemplateWindow = function (dropdownSet, isReadOnlyModeActive, htmlGetterFunction) {
    createUniversalTextDialogDivIfNeeded();
    const htmlString = htmlGetterFunction(dropdownSet, isReadOnlyModeActive);
    AJS.$("#edm-text-dialog-config").html(htmlString);
    AJS.dialog2("#edm-text-dialog-config").show();
    AJS.$('.edm-text-field-input').each(function () {
        resizable(this, 7);
    });
    if (!isReadOnlyModeActive) {
        AJS.$('.edm-text-set-editor-list').sortable();
    }
};

export const createDataMigrationWindow = function (htmlString) {
    createUniversalDataMigrationDialogDivIfNeeded();
    AJS.$("#edm-data-migration-dialog").html(htmlString);
    AJS.dialog2("#edm-data-migration-dialog").show();
};

export const createDeleteWarningWindow = function (setId, deleteButtonId, setName) {
    createWarningDialogDivIfNeeded();
    const htmlString = getDeleteWarningHtml(setId, deleteButtonId, setName);
    AJS.$('#edm-delete-warning-config').html(htmlString);
    AJS.dialog2("#edm-delete-warning-config").show();
};

export const generateUUID = function () {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        // noinspection EqualityComparisonWithCoercionJS copy pasted from Stack Overflow
        const r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
        return v.toString(16);
    });
};

//-----------------------------SET_EDITOR----------------------------------->>>
const readOutValuesOfStatusElement = function (element) {
    const optionId = AJS.$(element).attr('id');
    const optionName = AJS.$(element).find('.edm-option-field-input').val();
    const color = AJS.$(element).find('.edm-option-color-dropdown-div').find('input.color-picker-input').val();
    const subtle = AJS.$(element).find('.edm-option-subtle-checkbox').is(':checked');
    const textColor = AJS.$(element).find('.edm-checkbox-text-white').is(':checked');
    return ({
        id: optionId,
        name: optionName,
        color: color,
        subtle: subtle,
        textColor: textColor
    });
};

const readOutValuesOfTextElement = function (element) {
    const optionId = AJS.$(element).attr('id');
    const optionName = AJS.$(element).find('.edm-text-field-input').val();
    return ({
        id: optionId,
        name: optionName
    });
};

export const getSpaceKeyContext = function () {
    let spaceKey = "";
    if (AJS.params.spaceKey) {
        spaceKey = AJS.params.spaceKey
    }
    return spaceKey;
}

export const getCompleteStatusSetData = function () {
    let spaceKey = getSpaceKeyContext();
    const setName = AJS.$('.edm-status-editor-name').val();
    const setId = AJS.$('.edm-set-editor-list').attr('id');
    const optionsList = [];
    const elements = AJS.$('.edm-set-editor-list').find('.edm-editor-status-list-element');
    let i = 0;
    const len = elements.length;
    for (; i < len; i++) {
        const option = readOutValuesOfStatusElement(elements[i]);
        if (option.name.length >= 1) {
            optionsList.push(option);
        } else {
            Edm.Flag.someOptionsGotDeletedCauseInvalidName();
        }
    }
    return createCompleteSetDataObject(spaceKey, setId, setName, optionsList);
};

/**
 *
 * @param spaceKey empty for global
 * @param setId can be null in case of creation
 * @param setName
 * @param optionsList array of options
 */
export const createCompleteSetDataObject = function (spaceKey, setId, setName, optionsList) {
    return ({
        spaceKey: spaceKey,
        id: setId,
        name: setName,
        optionsList: optionsList
    });
}

export const getCompleteTextSetData = function () {
    let spaceKey = "";
    if (AJS.params.spaceKey) {
        spaceKey = AJS.params.spaceKey
    }
    const setName = AJS.$('.edm-set-editor-name').val();
    const setId = AJS.$('.edm-text-set-editor-list').attr('id');
    const optionsList = [];
    const elements = AJS.$('.edm-text-set-editor-list').find('.edm-editor-text-list-element');
    let i = 0;
    const len = elements.length;
    for (; i < len; i++) {
        const option = readOutValuesOfTextElement(elements[i]);
        if (option.name.length >= 1) {
            optionsList.push(option);
        } else {
            Edm.Flag.someOptionsGotDeletedCauseInvalidName();
        }
    }
    return ({
        spaceKey: spaceKey,
        id: setId,
        name: setName,
        optionsList: optionsList
    });
};

const chooseRightNameAndChange = function (setId, setName, nameElements) {
    for (let i = 0; i < nameElements.length; i++) {
        if (setId === AJS.$(nameElements[i]).prop('id')) {
            AJS.$(nameElements[i]).text(setName);
        }
    }
};

export const setTextNameOnConfigMainPage = function (setName, setId) {
    const nameElements = AJS.$('.edm-text-key-field');
    chooseRightNameAndChange(setId, setName, nameElements);
};

export const setStatusNameOnConfigMainPage = function (setName, setId) {
    const nameElements = AJS.$('.edm-status-key-field');
    chooseRightNameAndChange(setId, setName, nameElements);
};

export const deleteStatusNameFromPage = function (setId) {
    AJS.$('td#' + setId).closest('.statusInputs').remove();
};

export const deleteTextNameFromPage = function (setId) {
    AJS.$('td#' + setId).closest('.textInputs').remove();
};

//____________________Restore Options____________________
export const getStatusRestoreButtonData = function (button) {
    let spaceKey = "";
    if (AJS.params.spaceKey) {
        spaceKey = AJS.params.spaceKey;
    }

    return ({
        setId: $('.edm-history-table').attr('id'),
        optionId: button.getAttribute('data-edm-option-id'),
        optionName: button.getAttribute('data-edm-option-name'),
        optionColor: button.getAttribute('data-edm-option-color'),
        optionSubtle: button.getAttribute('data-edm-option-subtle'),
        optionTextColor: button.getAttribute('data-edm-option-textColor'),
        spaceKey: spaceKey
    });
};

export const getTextRestoreButtonData = function (button) {
    let spaceKey = "";
    if (AJS.params.spaceKey) {
        spaceKey = AJS.params.spaceKey;
    }

    return ({
        setId: $('.edm-history-table').attr('id'),
        optionId: button.getAttribute('data-edm-option-id'),
        optionName: button.getAttribute('data-edm-option-name'),
        spaceKey: spaceKey
    });
};

export const showFlagFromRestoreResponse = function (resp, button) {
    if (resp === "Restored Successfully") {
        $(button).replaceWith('<div class="edm-history-element-event-new">Restored</div>');
        Edm.Flag.restoredOptionSuccessFully();
    }
};