import {disableDropdownsForLock, initDropdownsNonPredefined, initDropdownsPredefined} from "./EasyDropdownMenu";
import {initStatusDropdowns} from "./Status-Menu";

AJS.toInit(function () {

    const initDropdowns = function (elementTarget) {
        initStatusDropdowns(elementTarget);
        initDropdownsNonPredefined(elementTarget);
        initDropdownsPredefined(elementTarget);
    };

    initDropdowns($("#content"));
    disableDropdownsForLock();

    $(window).on("load", function () {
        initDropdowns($("#content"));
        const observerConfig = {childList: true, characterData: true, subtree: true};
        const observer = new MutationObserver(function (mutations) {
            mutations.forEach((mutation) => {
                const newNodes = mutation.addedNodes;
                if (newNodes !== null) {
                    $(newNodes).each(function () {
                        initDropdowns($(this));
                        disableDropdownsForLock();
                    });
                }
            });
        });

        $('.metadata-summary-macro').each((index, element) => {
            observer.observe(element, observerConfig);
        });
    });
});