import {selectSelectedValue} from "./EasyDropdownMenu";
import {
    changeLinkToSpan,
    convertToSelectObject,
    convertToStatusSelectObject,
    convertToTextOptionSelectObject,
    convertToUniversalSetSelectObject,
    getCurrentOptionsArrayFromResp,
    templateGet,
    unwrapDiv
} from "./edm-select2";

AJS.toInit(function () {
    const dropdownGetStatusOptionsFromSetUrl = AJS.params.contextPath + '/rest/edm/1.0/edm/status/get-options-from-set';
    const dropdownGetTextOptionFromSetUrl = AJS.params.contextPath + '/rest/edm/1.0/edm/text/get-options-from-set';
    const getStatusDropdownSetNamesUrl = AJS.params.contextPath + '/rest/edm/1.0/edm/status/get-set-names';
    const getTextDropdownSetNamesUrl = AJS.params.contextPath + '/rest/edm/1.0/edm/text/get-set-names';
    const getAllGroupsUrl = AJS.params.contextPath + '/rest/edm/1.0/edm/groups/allWritableNames';
    const getAllCssClassesUrl = AJS.params.contextPath + '/rest/edm/1.0/edm/css/classes';

    const getData = function (setId, spaceKey) {
        if (!setId || setId === " ") {
            setId = "62d41cfd-9dc1-45ff-8991-defaultset";
        }
        return {
            setId: setId,
            spaceKey: spaceKey
        };
    };

    function createMacroInputFieldFunction(specificMacroFunction) {
        return function (param, options) {
            const isInitial = true;
            const paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameter());
            const input = AJS.$("input[type='text']", paramDiv);
            if (param.required) {
                input.keyup(AJS.MacroBrowser.processRequiredParameters);
            }
            options = options || {};

            specificMacroFunction(input, isInitial, paramDiv, options);

            return AJS.MacroBrowser.Field(paramDiv, input, options);
        }
    }

    function attachCurrentOptionValueListener(specificMacroFunction) {
        return function (param, options) {
            const parameterField = AJS.MacroBrowser.ParameterFields["_hidden"](param, options);
            AJS.$('input#macro-param-option-id').on('change', function () {
                var val = specificMacroFunction();
                if (val.length > 0) {
                    parameterField.setValue(val);
                }
            });
            return parameterField;
        }
    }

//----------------------------------------------Groups-Dropdown-Field ++++++ CSS_STYLES---------------------------------------------------------------------------
    const createUniversalGroupsDropdown = function (input) {
        Edm.Rest.get(getAllGroupsUrl, function (resp) {
            createDropdownFromResponse(input, resp, true);
        });
    };

    const createUniversalCssDropdown = function (input) {
        Edm.Rest.post(getAllCssClassesUrl, {spaceKey: AJS.params.spaceKey}, function (resp) {
            createDropdownFromResponse(input, resp, false)
        });
    };

//---------------------------------------------Current-Option-Id-Listeners----------------------------------------------------------------------
    function attachUniversalOptionIdListener(input, isInitial, dropdownFunction) {
        AJS.$('input#macro-param-set-id').on('change', function () {
            if (!isInitial) {
                AJS.$('input#macro-param-option-id').val('')
            } else {
                isInitial = false;
            }
            dropdownFunction(input);
        });

        AJS.$('input#macro-param-multi-dropdown').on('change', function () {
            dropdownFunction(input)
        });
    }

    const getStatusMacroCurrentOptionValue = function () {
        return $('div#macro-param-div-option-id').find('.select2-chosen').find('span').text();
    };

    const getTextMacroCurrentOptionValue = function () {
        const multi = AJS.$('#macro-param-multi-dropdown').is(':checked');
        if (!multi) {
            return AJS.$('div#macro-param-div-option-id').find('.select2-chosen').text();
        }
        return getMultipleOptionIdsValue()
    };

    const getMultipleOptionIdsValue = function () {
        const multipleInputElements = AJS.$('div#macro-param-div-option-id .select2-search-choice div');
        return multipleInputElements.map((index, element) => {
            return element.textContent;
        }).get().join(",");
    };

    const createSelect2ForStatusOptionId = function (input) {
        const setId = AJS.$('input#macro-param-set-id').val();
        Edm.Rest.post(dropdownGetStatusOptionsFromSetUrl, getData(setId, AJS.params.spaceKey), function (resp) {
            createStatusOptionsDropdownFromResponse(input, resp);
            AJS.MacroBrowser.Editor.processRequiredParameters();
        });
    };

    const createSelect2ForTextOptionId = function (input) {
        const setId = AJS.$('input#macro-param-set-id').val();
        const multi = AJS.$('#macro-param-multi-dropdown').is(':checked');
        const includeBlank = AJS.$('#macro-param-include-blank').is(':checked');

        Edm.Rest.post(dropdownGetTextOptionFromSetUrl, getData(setId, AJS.params.spaceKey), function (resp) {
            createTextOptionsDropdownFromResponse(input, resp, multi, includeBlank);
            AJS.MacroBrowser.Editor.processRequiredParameters();
        });
    };

    function ifMultiOrIncludeBlankChange() {
        const input = AJS.$('#macro-param-option-id');
        const multi = AJS.$('#macro-param-multi-dropdown').is(':checked');
        if (multi) {
            AJS.$('div#macro-param-div-include-blank').hide();
            AJS.$('div#macro-param-div-separator').show();
        } else {
            AJS.$('div#macro-param-div-include-blank').show();
            AJS.$('div#macro-param-div-separator').hide();
        }
        input.select2("destroy");
        createSelect2ForTextOptionId(input);
    }

//----------------------------------Set-Id-FieldCreators------------------------------------------------------------------------------------------------------------
    const setUniversalSetDropdown = function (input, resp) {
        createUniversalSetDropdownFromResponse(input, resp);
        const inputValue = input.val();
        input.val(inputValue).change();
    };

    const statusSetIdDropdownCreator = function (input) {
        Edm.Rest.post(getStatusDropdownSetNamesUrl, {spaceKey: AJS.params.spaceKey}, function (resp) {
            setUniversalSetDropdown(input, resp)
        });
    };

    const textSetIdDropdownCreator = function (input) {
        Edm.Rest.post(getTextDropdownSetNamesUrl, {spaceKey: AJS.params.spaceKey}, function (resp) {
            setUniversalSetDropdown(input, resp)
        });
    };

//-------------------------------------------------------------------------------------------------------------------------------------------------------
    let initialIsMulti;

    $(document).on('change', 'input#macro-param-multi-dropdown, input#macro-param-include-blank', function () {
        ifMultiOrIncludeBlankChange()
    });

    AJS.MacroBrowser.setMacroJsOverride("easy-dropdown-menu", {
        fields: {
            string: {
                "options": createMacroInputFieldFunction(function (input, isInitial, paramDiv, options) {
                    options.setValue = function (value) {
                        createMultiDropdownWithExistingValues(input, value, paramDiv);
                    };
                }),
                "permitted-groups": createMacroInputFieldFunction(function (input) {
                    Edm.Rest.get(getAllGroupsUrl, function (resp) {
                        createDropdownFromResponse(input, resp, true);
                    });
                }),
                "css-style-class": createMacroInputFieldFunction(function (input) {
                    Edm.Rest.post(getAllCssClassesUrl, {spaceKey: AJS.params.spaceKey}, function (resp) {
                        createDropdownFromResponse(input, resp, false)
                    });
                }),
                "current-option": function (param, options) {
                    const paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameter());
                    paramDiv.hide();
                    const input = AJS.$("input", paramDiv);
                    if (param.required) {
                        input.keyup(AJS.MacroBrowser.processRequiredParameters);
                    }
                    return AJS.MacroBrowser.Field(paramDiv, input, options);
                }
            }
        },
        beforeParamsSet: function (paramMap) {
            initialIsMulti = paramMap['multi-dropdown'];
            if (initialIsMulti) {
                AJS.$('div#macro-param-div-include-blank').hide();
            }
            return paramMap;
        }
    });

    AJS.MacroBrowser.setMacroJsOverride("easy-dropdown-menu-predefined", {
        fields: {
            string: {
                "set-id": createMacroInputFieldFunction(function (input) {
                    textSetIdDropdownCreator(input);
                }),
                "option-id": createMacroInputFieldFunction(function (input, isInitial) {
                    attachUniversalOptionIdListener(input, isInitial, createSelect2ForTextOptionId);
                }),
                "permitted-groups": createMacroInputFieldFunction(function (input) {
                    createUniversalGroupsDropdown(input);
                }),
                "css-style-class": createMacroInputFieldFunction(function (input) {
                    createUniversalCssDropdown(input);
                }),
                "current-option-value": attachCurrentOptionValueListener(getTextMacroCurrentOptionValue)
            }
        },
        beforeParamsSet: function (paramMap) {
            initialIsMulti = paramMap['multi-dropdown'];
            if (initialIsMulti) {
                AJS.$('div#macro-param-div-include-blank').hide();
            }
            return paramMap;
        }
    });

    AJS.MacroBrowser.setMacroJsOverride("easy-dropdown-menu-status", {
        fields: {
            string: {
                "set-id": createMacroInputFieldFunction(function (input) {
                    statusSetIdDropdownCreator(input);
                }),
                "option-id": createMacroInputFieldFunction(function (input, isInitial) {
                    attachUniversalOptionIdListener(input, isInitial, createSelect2ForStatusOptionId);
                }),
                "permitted-groups": createMacroInputFieldFunction(function (input) {
                    createUniversalGroupsDropdown(input);
                }),
                "current-option-value": attachCurrentOptionValueListener(getStatusMacroCurrentOptionValue)
            }
        }
    });

    AJS.MacroBrowser.setMacroJsOverride("easy-dropdown-menu-edit-mode", {
        fields: {
            string: {
                "set-id": createMacroInputFieldFunction(function (input) {
                    textSetIdDropdownCreator(input);
                }),
                "option-id": createMacroInputFieldFunction(function (input, isInitial) {
                    attachUniversalOptionIdListener(input, isInitial, createSelect2ForTextOptionId);
                }),
                "permitted-groups": createMacroInputFieldFunction(function (input) {
                    createUniversalGroupsDropdown(input);
                }),
                "css-style-class": createMacroInputFieldFunction(function (input) {
                    createUniversalCssDropdown(input);
                }),
                "current-option-value": attachCurrentOptionValueListener(getTextMacroCurrentOptionValue)
            }
        },
        beforeParamsSet: function (paramMap) {
            initialIsMulti = paramMap['multi-dropdown'];
            if (!initialIsMulti) {
                AJS.$('div#macro-param-div-separator').hide();
            }
            return paramMap;
        }
    });

    const createMultiDropdownWithoutExistingValues = function (input) {
        input.auiSelect2({
            tags: true,
            tokenSeparators: [","],
            data: [],
            multiple: true,
            minimumResultsForSearch: -1,
            dropdownCssClass: "select2-hidden",
            createSearchChoice: function (term) {
                return {
                    id: term,
                    text: term
                };
            },
            formatNoMatches: function () {
                return "";
            }
        });
    };

    const createMultiDropdownWithExistingValues = function (input, value, paramDiv) {
        createMultiDropdownWithoutExistingValues(input);
        const $dropdownOptions = $('#macro-param-div-options');
        $('ul.select2-choices', $dropdownOptions).sortable({
            containment: 'parent',
            update: () => {
                const values = $('.select2-search-choice', $dropdownOptions)
                    .toArray()
                    .map(element => $(element).text().trim())
                    .map(value => ({id: value, text: value}));
                input.auiSelect2('data', values);
                AJS.$('button.button-panel-button').enable();
            }
        });
        const existingValues = convertToSelectObject(value.split(","));
        if (existingValues.length) {
            input.auiSelect2("data", existingValues);
        }
        const list = AJS.$("li.select2-search-choice", paramDiv.first());
        AJS.$.each(list, function (cursor, entry) {
            changeLinkToSpan(entry);
            unwrapDiv(entry);
        });
    };

    const createDropdownFromResponse = function (input, resp, multi) {
        input.auiSelect2({
            multiple: multi,
            allowClear: true,
            data: convertToSelectObject(resp)
        });
    };

    const createStatusOptionsDropdownFromResponse = function (input, resp) {
        input.auiSelect2({
            dropdownCssClass: "edm-status-dropdownClass",
            containerCssClass: "dropdowncontainer-css",
            multiple: false,
            allowClear: true,
            data: convertToStatusSelectObject((resp)),
            templateResult: templateGet(convertToStatusSelectObject(resp)),
            escapeMarkup: function (m) {
                return m;
            }
        });
    };

    const createTextOptionsDropdownFromResponse = function (input, resp, multi, includeBlank) {
        const currentOptionsArray = getCurrentOptionsArrayFromResp(input, resp);
        if (includeBlank && !multi) {
            resp = [{id: "", name: ""}].concat(resp);
        }
        input.auiSelect2({
            multiple: multi,
            allowClear: true,
            data: convertToTextOptionSelectObject(resp)
        });
        selectSelectedValue(input, currentOptionsArray, multi);
    };

    const createUniversalSetDropdownFromResponse = function (input, resp) {
        input.auiSelect2({
            allowClear: true,
            data: convertToUniversalSetSelectObject(resp)

        });
    };



});

