/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.taskUtils.core;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import eps.focuspro.taskUtils.core.EdmLongRunningTask;
import eps.focuspro.taskUtils.core.ResponseData;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager {
    private final Cache<String, ResponseData> responseCache;
    private LongRunningTaskManager longRunningTaskManager;
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);

    public TaskManager(CacheManager cacheManager, LongRunningTaskManager longRunningTaskManager) {
        this.responseCache = cacheManager.getCache("EDM Completed Task Cache", (CacheLoader)new CacheLoader<String, ResponseData>(){

            @Nonnull
            public ResponseData load(@Nonnull String key) {
                return new ResponseData(404, null);
            }
        }, new CacheSettingsBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).expireAfterWrite(5L, TimeUnit.MINUTES).remote().build());
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public ResponseData get(String responseId) {
        return (ResponseData)this.responseCache.get((Object)responseId);
    }

    public String start(EdmLongRunningTask task) {
        return this.longRunningTaskManager.startLongRunningTask(AuthenticatedUserThreadLocal.get(), (LongRunningTask)task).toString();
    }

    public void add(String responseId, ResponseData response) {
        log.info("Putting task in cache with response id: " + responseId);
        this.responseCache.put((Object)responseId, (Object)response);
    }
}

