/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.search;

import com.atlassian.confluence.pages.Page;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import eps.focuspro.search.core.PageConverter;
import eps.focuspro.search.util.SetSplitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingExecuter {
    private static final int MAX_SET_SIZE = 20;
    private final PageConverter pageConverter;
    private final TransactionTemplate transactionTemplate;
    private final SetSplitter setSplitter;
    private static final Logger log = LoggerFactory.getLogger(MappingExecuter.class);

    public MappingExecuter(PageConverter pageConverter, TransactionTemplate transactionTemplate) {
        this.pageConverter = pageConverter;
        this.transactionTemplate = transactionTemplate;
        this.setSplitter = new SetSplitter();
    }

    public List<Long> handlePages(Map<String, Set<String>> mapping, Function<Page, Long> pageFunction) {
        ArrayList<Long> handledPages = new ArrayList<Long>();
        mapping.forEach((spaceKey, set) -> {
            log.info("Trying to update pages in space: " + spaceKey);
            List<Set<String>> splittedSets = this.setSplitter.splitSet((Set<String>)set, 20);
            log.info("Splitting the pages in the space to " + splittedSets.size() + " transactions");
            for (Set<String> splittedSet : splittedSets) {
                this.transactionTemplate.execute(() -> {
                    for (String title : splittedSet) {
                        Page page = this.pageConverter.convertToPage((String)spaceKey, title);
                        if (page == null) continue;
                        log.info("Updating Page: " + page.getDisplayTitle());
                        Long pageId = (Long)pageFunction.apply(page);
                        if (pageId == 0L) continue;
                        handledPages.add(pageId);
                    }
                    return null;
                });
            }
        });
        return handledPages;
    }

    public int getTotal(Map<String, Set<String>> pageMapping) {
        int total = 0;
        for (Set<String> set : pageMapping.values()) {
            total += set.size();
        }
        return total;
    }
}

