/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest.helper;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.OperationTrigger;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.mail.notification.ConversionContextCreator;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.rest.page.MacroUpdateResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdmPageManager {
    private static final Logger log = LoggerFactory.getLogger(MacroUpdateResources.class);
    private final PageManager pageManager;
    private final XhtmlContent xhtmlContent;
    private final TransactionTemplate transactionTemplate;
    private final EdmSettingsManager edmSettingsManager;

    public EdmPageManager(PageManager pageManager, XhtmlContent xhtmlContent, TransactionTemplate transactionTemplate, EdmSettingsManager edmSettingsManager) {
        this.pageManager = pageManager;
        this.xhtmlContent = xhtmlContent;
        this.transactionTemplate = transactionTemplate;
        this.edmSettingsManager = edmSettingsManager;
    }

    public void updatePage(Page page, MacroDefinitionUpdater macroDefinitionUpdater, boolean silentUpdate) {
        this.transactionTemplate.execute(() -> {
            try {
                ConversionContext conversionContext = new ConversionContextCreator().createConversionContext((ContentEntityObject)page);
                String updatedPageBody = this.xhtmlContent.updateMacroDefinitions(page.getBodyAsString(), conversionContext, macroDefinitionUpdater);
                if (!silentUpdate) {
                    this.saveWithNewPageVersion(page, updatedPageBody);
                } else {
                    this.savePageSilently(page, updatedPageBody);
                }
            }
            catch (XhtmlException e) {
                log.error("There was an xhtml exception when trying to update the page", (Throwable)e);
                throw new RuntimeException("There was an xhtml exception when trying to update the macro");
            }
            return null;
        });
    }

    private void saveWithNewPageVersion(Page page, String updatedPageBody) {
        this.pageManager.saveNewVersion((ContentEntityObject)page, page1 -> page1.setBodyAsString(updatedPageBody), this.getSaveContext());
    }

    private void savePageSilently(Page page, String updatedPageBody) {
        page.setBodyAsString(updatedPageBody);
        this.pageManager.saveContentEntity((ContentEntityObject)page, this.getSaveContext());
    }

    private SaveContext getSaveContext() {
        return ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)new DefaultSaveContext.Builder().updateLastModifier(true).suppressNotifications(this.edmSettingsManager.getGlobalSettings().isSuppressNotifications())).updateTrigger((OperationTrigger)PageUpdateTrigger.EDIT_PAGE)).build();
    }
}

