/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest.edmindexing;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.ConfluenceIndexer;
import eps.focuspro.search.MappingExecuter;
import eps.focuspro.search.PageSearcher;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdmReIndexer {
    private final ConfluenceIndexer confluenceIndexer;
    private final Logger log = LoggerFactory.getLogger(EdmReIndexer.class);
    private final PageSearcher pageSearcher;
    private final MappingExecuter mappingExecuter;

    public EdmReIndexer(ConfluenceIndexer confluenceIndexer, PageSearcher pageSearcher, MappingExecuter mappingExecuter) {
        this.confluenceIndexer = confluenceIndexer;
        this.pageSearcher = pageSearcher;
        this.mappingExecuter = mappingExecuter;
    }

    public void reIndexSetIds(String setId) {
        List<Page> pagesForSetId = this.pageSearcher.getPagesForSetId(setId);
        this.log.info("Adding " + String.valueOf(pagesForSetId) + " pages that have the dropdownSetId " + setId + " to the reIndexQueue");
        for (Page page : pagesForSetId) {
            this.reIndexPage(page);
        }
    }

    public int reindexAllMacros() {
        Map<String, Set<String>> mappings = this.pageSearcher.getPagesMappingForMacroName("easy-dropdown-menu-status", "easy-dropdown-menu-predefined", "easy-dropdown-menu-edit-mode");
        List<Long> longs = this.mappingExecuter.handlePages(mappings, this::reIndexPage);
        this.log.info("Added " + longs.size() + " pages to the ReindexQueue");
        return longs.size();
    }

    private long reIndexPage(Page page) {
        if (page != null) {
            this.log.info("Reindexing page with title" + page.getDisplayTitle());
            this.confluenceIndexer.reIndex((Searchable)page);
            return page.getId();
        }
        this.log.info("Page was null");
        return 0L;
    }
}

