/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration.macroMigration;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import eps.focuspro.edm.persistence.config.daos.Version1MappingsDao;
import eps.focuspro.macros.DropdownMacroParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EDMMacroSchemaMigrator {
    private final DropdownMacroParameters dropdownMacroParameters;
    private Version1MappingsDao version1MappingsDao;
    private static final String SET_ID = "set-id";
    private static final String OPTION_ID = "option-id";
    private static final String OPTIONS = "options";
    private static final String CURRENT_OPTION = "current-option";
    private static final String FAIL = "FAIL";

    public EDMMacroSchemaMigrator(DropdownMacroParameters dropdownMacroParameters, Version1MappingsDao version1MappingsDao) {
        this.dropdownMacroParameters = dropdownMacroParameters;
        this.version1MappingsDao = version1MappingsDao;
    }

    public MacroDefinition migrateEdmMacro(MacroDefinition oldMacro, ConversionContext conversionContext) {
        MacroDefinition macro = new MacroDefinition(oldMacro);
        String spaceKey = conversionContext.getSpaceKey();
        String setKey = this.getSetKeyFromMacro(macro);
        List<String> optionKeys = this.getOptionKeysListFromMacro(macro);
        if (this.dropdownMacroParameters.isStatusDropdown(macro.getName())) {
            if (optionKeys.isEmpty()) {
                optionKeys.add("grey");
            }
            if (setKey.equals("")) {
                setKey = "Default";
            }
        }
        String setId = "";
        Map<Object, Object> optionsMapping = new HashMap();
        Map<String, String> spaceSetMapping = this.version1MappingsDao.getSpaceSetMapping(spaceKey);
        if (spaceSetMapping.containsKey(setKey)) {
            setId = spaceSetMapping.get(setKey);
            optionsMapping = this.version1MappingsDao.getOptionMapping(setId);
        } else {
            Map<String, String> globalSetMapping = this.version1MappingsDao.getGlobalSetMapping();
            if (globalSetMapping.containsKey(setKey)) {
                setId = globalSetMapping.get(setKey);
                optionsMapping = this.version1MappingsDao.getOptionMapping(setId);
            }
        }
        if (optionsMapping.get(setId) != null) {
            Map detailedOptionsMapping = (Map)optionsMapping.get(setId);
            List<String> optionIdList = this.getOptionIdListFromMacro(optionKeys, detailedOptionsMapping);
            String optionId = this.convertOptionIdListToString(optionIdList);
            macro.setParameter(SET_ID, setId);
            macro.setParameter(OPTION_ID, optionId);
            macro.setTypedParameter(SET_ID, (Object)setId);
            macro.setTypedParameter(OPTION_ID, (Object)optionId);
            macro.setSchemaVersion(2);
            return macro;
        }
        macro.setParameter(SET_ID, FAIL);
        macro.setParameter(OPTION_ID, FAIL);
        macro.setTypedParameter(SET_ID, (Object)FAIL);
        macro.setTypedParameter(OPTION_ID, (Object)FAIL);
        macro.setSchemaVersion(2);
        return macro;
    }

    private String getSetKeyFromMacro(MacroDefinition macro) {
        if (macro.getParameter(OPTIONS) != null && !macro.getParameter(OPTIONS).equals("")) {
            return macro.getParameter(OPTIONS).trim();
        }
        return "";
    }

    private List<String> getOptionKeysListFromMacro(MacroDefinition macro) {
        ArrayList<String> optionKeysList = new ArrayList<String>();
        if (macro.getParameter(CURRENT_OPTION) != null && !macro.getParameter(CURRENT_OPTION).equals("")) {
            String optionIdString = macro.getParameter(CURRENT_OPTION).trim();
            optionKeysList = new ArrayList<String>(Arrays.asList(optionIdString.split("\\s*,\\s*")));
        }
        return optionKeysList;
    }

    private List<String> getOptionIdListFromMacro(List<String> optionKeysList, Map<String, String> detailedOptionsMapping) {
        ArrayList<String> optionIdList = new ArrayList<String>();
        for (String optionKey : optionKeysList) {
            String optionId = detailedOptionsMapping.get(optionKey);
            if (optionId == null || optionId.equals("")) continue;
            optionIdList.add(optionId);
        }
        return optionIdList;
    }

    private String convertOptionIdListToString(List<String> optionIdList) {
        if (!optionIdList.isEmpty()) {
            return String.join((CharSequence)",", optionIdList);
        }
        return "";
    }
}

