/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.configui.spaceconfig.SpaceSettings;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.migration.LozengeSettingsConverter;
import eps.focuspro.migration.MigrationTask;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusMigrationTaskInvoker {
    private final SpaceSettings spaceSettings;
    private final LozengeSettingsConverter lozengeSettingsConverter;
    private final SetEntityAccessor setEntityAccessor;
    private static final Logger log = LoggerFactory.getLogger(StatusMigrationTaskInvoker.class);

    public StatusMigrationTaskInvoker(SpaceSettings spaceSettings, LozengeSettingsConverter lozengeSettingsConverter, SetEntityAccessor setEntityAccessor) {
        this.spaceSettings = spaceSettings;
        this.lozengeSettingsConverter = lozengeSettingsConverter;
        this.setEntityAccessor = setEntityAccessor;
    }

    public void workGlobal() {
        if (this.setEntityAccessor.areThereNoStatusSetsPresent("")) {
            log.info("Starting Global Status Set Migration");
            this.migrateGlobalStatusSettings();
            log.info("Finished Global Status Set Migration");
        } else {
            log.info("Didn't migrate global status sets from plugin settings as there were already sets present!");
        }
    }

    public void workForSpace(String spaceKey) {
        if (this.setEntityAccessor.areThereNoStatusSetsPresent(spaceKey)) {
            if (!this.spaceSettings.loadLozenge(spaceKey).isEmpty()) {
                log.info("Starting status set migration of space: " + spaceKey);
                this.startSpaceMigrationTask(spaceKey);
                log.info("Finished status set migration of space: " + spaceKey);
            } else {
                log.info("Didn't migrate status sets from plugin settings of space: " + spaceKey + " because there was no data in space pluginsettings");
            }
        } else {
            log.info("Didn't migrate status sets from plugin settings of space: " + spaceKey + " because there was already data in active objects found");
        }
    }

    private void migrateGlobalStatusSettings() {
        MigrationTask<Map<String, Map<String, String>>, List<DropdownSet<LozengeOption>>, Map<String, String>, Map<String, Map<String, String>>> migrationTask = new MigrationTask<Map<String, Map<String, String>>, List<DropdownSet<LozengeOption>>, Map<String, String>, Map<String, Map<String, String>>>();
        migrationTask.setLoader(this.lozengeSettingsConverter.createGlobalSettingsSupplier);
        migrationTask.setConverter(this.lozengeSettingsConverter.createNewSets);
        migrationTask.setSetMapper(this.lozengeSettingsConverter.setMappingFunction);
        migrationTask.setOptionsMapper(this.lozengeSettingsConverter.statusOptionsMapping);
        migrationTask.setSetSaver(this.lozengeSettingsConverter.globalSetSaver);
        migrationTask.setMappingSaver(this.lozengeSettingsConverter.globalMappingSaver);
        migrationTask.migrate();
    }

    private void startSpaceMigrationTask(String spaceKey) {
        MigrationTask<Map<String, Map<String, String>>, List<DropdownSet<LozengeOption>>, Map<String, String>, Map<String, Map<String, String>>> migrationTask = new MigrationTask<Map<String, Map<String, String>>, List<DropdownSet<LozengeOption>>, Map<String, String>, Map<String, Map<String, String>>>();
        migrationTask.setLoader(this.lozengeSettingsConverter.createSpaceSettingsSupplier(spaceKey));
        migrationTask.setConverter(this.lozengeSettingsConverter.createNewSets);
        migrationTask.setSetMapper(this.lozengeSettingsConverter.setMappingFunction);
        migrationTask.setOptionsMapper(this.lozengeSettingsConverter.statusOptionsMapping);
        migrationTask.setSetSaver(this.lozengeSettingsConverter.spaceSetSaver(spaceKey));
        migrationTask.setMappingSaver(this.lozengeSettingsConverter.spaceMappingSaver(spaceKey));
        migrationTask.migrate();
    }
}

