/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.license;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import eps.focuspro.license.LicenseStatus;
import javax.ws.rs.core.Response;

public class LicenseValidator {
    private final PluginLicenseManager licenseManager;

    public LicenseValidator(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public LicenseStatus validatePluginLicense() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                return this.getLicenseStatus((LicenseError)license.getError().get());
            }
            return LicenseStatus.VALID;
        }
        return LicenseStatus.OTHER_MISMATCH;
    }

    public Response getResponse(LicenseStatus licenseStatus) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.getResponseString(licenseStatus)).build();
    }

    public String getResponseString(LicenseStatus licenseStatus) {
        return "<b>License key invalid!</b> </br>" + (switch (licenseStatus) {
            case LicenseStatus.EXPIRED -> "Invalid license: Your evaluation license of \"Easy Dropdown Menu\" expired. Please use the link below or the 'Buy now' button in you Add-ons configuration to purchase a new license.";
            case LicenseStatus.TYPE_MISMATCH -> "Invalid license: Your \"Easy Dropdown Menu\" license does not match the license type on this Atlassian application. Please get a valid license type for \"Easy Dropdown Menu\" and try again.";
            case LicenseStatus.USER_MISMATCH -> "Invalid license: Your \"Easy Dropdown Menu\" is only licensed for less users than your Atlassian application. Please get a \"Easy Dropdown Menu\" license for same amount of users as your Atlassian application and try again.";
            case LicenseStatus.VERSION_MISMATCH -> "Invalid license: Your license for maintenance of \"Easy Dropdown Menu\" is not valid for your version. Please use the link below or the 'Buy now' button in your Add-ons configuration to renew your \"Easy Dropdown Menu\" license.";
            default -> "You don't have permission to make use of \"Easy Dropdown Menu\". Please check your license for validity.";
        }) + " <a href=https://marketplace.atlassian.com/plugins/eps.focuspro.EasyDropdownMenu target=\"_blank\">Get a license key</a> ";
    }

    private LicenseStatus getLicenseStatus(LicenseError licenseError) {
        switch (licenseError) {
            case EXPIRED: {
                return LicenseStatus.EXPIRED;
            }
            case TYPE_MISMATCH: {
                return LicenseStatus.TYPE_MISMATCH;
            }
            case USER_MISMATCH: {
                return LicenseStatus.USER_MISMATCH;
            }
            case VERSION_MISMATCH: {
                return LicenseStatus.VERSION_MISMATCH;
            }
        }
        return LicenseStatus.OTHER_MISMATCH;
    }
}

