/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence.config.migration;

import eps.focuspro.configui.DatabaseSettings;
import eps.focuspro.configui.DatabaseSettingsManager;
import eps.focuspro.configui.spaceconfig.SpaceSettings;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSpaceSettings;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnTheFlyMigrator {
    private final DatabaseSettingsManager databaseSettingsManager;
    private final SpaceSettings spaceSettings;
    private static final Logger log = LoggerFactory.getLogger(OnTheFlyMigrator.class);

    public OnTheFlyMigrator(DatabaseSettingsManager databaseSettingsManager, SpaceSettings spaceSettings) {
        this.databaseSettingsManager = databaseSettingsManager;
        this.spaceSettings = spaceSettings;
    }

    public EdmGlobalSettings createGlobalSettings() {
        log.info("Migrating Global Easy Dropdown Menu Settings");
        return this.createFromPluginSettings();
    }

    public EdmSpaceSettings migrateSpaceSettings(String spaceKey) {
        List<String> cssClasses = this.spaceSettings.loadCss(spaceKey);
        List<String> groups = this.spaceSettings.loadGroups(spaceKey);
        if (cssClasses.isEmpty() && groups.isEmpty()) {
            return null;
        }
        return new EdmSpaceSettings(spaceKey, cssClasses, groups);
    }

    private EdmGlobalSettings createFromPluginSettings() {
        DatabaseSettings databaseSettings = this.databaseSettingsManager.getDbSettings();
        return new EdmGlobalSettings(databaseSettings.getDefaultEditModeCss(), databaseSettings.getDefaultNonPredifinedCss(), databaseSettings.getDefaultPredefinedCss(), databaseSettings.isSuppressNotifications(), databaseSettings.isAllowAnonymous(), databaseSettings.isAllowWithoutEditPermissions(), databaseSettings.getCssClasses(), databaseSettings.getPermittedGroupNames());
    }
}

