/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence.config.daos;

import com.atlassian.activeobjects.external.ActiveObjects;
import eps.focuspro.edm.persistence.entities.OptionIdMapping;
import eps.focuspro.edm.persistence.entities.SetIdMapping;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.java.ao.DBParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version1MappingsDao {
    private final ActiveObjects ao;
    private static final Logger log = LoggerFactory.getLogger(Version1MappingsDao.class);

    public Version1MappingsDao(ActiveObjects ao) {
        this.ao = Objects.requireNonNull(ao);
    }

    public Map<String, String> getGlobalSetMapping() {
        return this.getSetsForCondition(this::globalSetFilter, "");
    }

    public Map<String, String> getSpaceSetMapping(String spaceKey) {
        return this.getSetsForCondition(this::spaceSetFilter, spaceKey);
    }

    public Map<String, Map<String, String>> getOptionMapping(String setId) {
        Map<String, String> optionMap = this.getOptionsForSet(setId);
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        map.put(setId, optionMap);
        return map;
    }

    public void saveSetIdMappings(Map<String, String> mapping, String spaceKey) {
        mapping.forEach((key, value) -> {
            SetIdMapping setIdMapping = (SetIdMapping)this.ao.create(SetIdMapping.class, new DBParam[0]);
            setIdMapping.setOldName((String)key);
            setIdMapping.setSetId((String)value);
            setIdMapping.setSpaceKey(spaceKey);
            setIdMapping.save();
        });
    }

    public void saveOptionIdMappings(Map<String, Map<String, String>> mapping) {
        mapping.forEach((setId, map) -> map.forEach((optionName, optionId) -> {
            OptionIdMapping optionIdMapping = (OptionIdMapping)this.ao.create(OptionIdMapping.class, new DBParam[0]);
            optionIdMapping.setOldOptionName((String)optionName);
            optionIdMapping.setNewOptionId((String)optionId);
            optionIdMapping.setSetId((String)setId);
            optionIdMapping.save();
        }));
    }

    private Map<String, String> getSetsForCondition(BiFunction<SetIdMapping, String, Boolean> filter, String spaceKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (SetIdMapping setIdMapping : (SetIdMapping[])this.ao.find(SetIdMapping.class)) {
            if (!filter.apply(setIdMapping, spaceKey).booleanValue()) continue;
            String oldName = setIdMapping.getOldName();
            String setId = setIdMapping.getSetId();
            if (!StringUtils.isNotBlank((CharSequence)oldName) || !StringUtils.isNotBlank((CharSequence)setId)) continue;
            map.put(oldName, setId);
        }
        return map;
    }

    private Map<String, String> getOptionsForSet(String setId) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.ao.stream(OptionIdMapping.class, mapping -> {
            if (setId.equals(mapping.getSetId())) {
                String oldName = mapping.getOldOptionName();
                String optionId = mapping.getNewOptionId();
                if (StringUtils.isNotBlank((CharSequence)oldName) && StringUtils.isNotBlank((CharSequence)optionId)) {
                    map.put(oldName, optionId);
                }
            }
        });
        return map;
    }

    private boolean globalSetFilter(SetIdMapping setIdMapping, String spaceKey) {
        String spaceKeyIndMapping = setIdMapping.getSpaceKey();
        return spaceKeyIndMapping == null || spaceKeyIndMapping.isEmpty();
    }

    private boolean spaceSetFilter(SetIdMapping setIdMapping, String spaceKey) {
        return spaceKey.equals(setIdMapping.getSpaceKey());
    }
}

