/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence.config.daos;

import com.atlassian.activeobjects.external.ActiveObjects;
import eps.focuspro.configui.DatabaseSettings;
import eps.focuspro.configui.DatabaseSettingsManager;
import eps.focuspro.edm.persistence.entities.EdmSchemaVersion;
import java.util.Objects;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaVersionHandler {
    private final DatabaseSettingsManager databaseSettingsManager;
    private final ActiveObjects ao;
    private static final Logger log = LoggerFactory.getLogger(SchemaVersionHandler.class);

    public SchemaVersionHandler(DatabaseSettingsManager databaseSettingsManager, ActiveObjects ao) {
        this.databaseSettingsManager = databaseSettingsManager;
        this.ao = Objects.requireNonNull(ao);
    }

    public int getGlobalSchemaVersion() {
        EdmSchemaVersion schemaVersionEntity = this.getSchemaVersionEntity();
        return schemaVersionEntity == null ? 0 : schemaVersionEntity.getSchemaVersion();
    }

    public int getAndUpdateSchemaVersion() {
        int bandanaSchemaVersion;
        EdmSchemaVersion edmSchemaVersion = this.getSchemaVersionEntityAndAssureConsistency();
        if (edmSchemaVersion.getSchemaVersion() != 4 && (bandanaSchemaVersion = this.getBandanaSchemaVersion()) > edmSchemaVersion.getSchemaVersion()) {
            log.info("Updating EDM Schema version from {} to {} (Schema Version Value from Bandana Store)", (Object)edmSchemaVersion.getSchemaVersion(), (Object)bandanaSchemaVersion);
            edmSchemaVersion.setSchemaVersion(bandanaSchemaVersion);
            edmSchemaVersion.save();
        }
        return edmSchemaVersion.getSchemaVersion();
    }

    public void saveGlobalSchemaVersion(int version) {
        int finalVersion = this.saveAoSchemaVersion(version);
        log.info("Updated EDM Schema version: '{}'", (Object)finalVersion);
    }

    private int saveAoSchemaVersion(int version) {
        log.info("Trying to save new AoSchemaVersion of the Easy Dropdown Menu: Version: " + version);
        EdmSchemaVersion schemaVersionEntity = this.getSchemaVersionEntity();
        if (schemaVersionEntity == null) {
            schemaVersionEntity = (EdmSchemaVersion)this.ao.create(EdmSchemaVersion.class, new DBParam[0]);
        }
        schemaVersionEntity.setSchemaVersion(version);
        schemaVersionEntity.save();
        return schemaVersionEntity.getSchemaVersion();
    }

    private int getBandanaSchemaVersion() {
        DatabaseSettings dbSettings = this.databaseSettingsManager.getDbSettings();
        return dbSettings.getSchemaVersion();
    }

    private EdmSchemaVersion getSchemaVersionEntityAndAssureConsistency() {
        EdmSchemaVersion[] edmSchemaVersions = (EdmSchemaVersion[])this.ao.find(EdmSchemaVersion.class);
        if (edmSchemaVersions.length > 1) {
            for (int i = 1; i < edmSchemaVersions.length; ++i) {
                this.ao.delete(new RawEntity[]{edmSchemaVersions[i]});
            }
        }
        if (edmSchemaVersions.length == 0) {
            EdmSchemaVersion edmSchemaVersion = (EdmSchemaVersion)this.ao.create(EdmSchemaVersion.class, new DBParam[0]);
            edmSchemaVersion.setSchemaVersion(0);
            edmSchemaVersion.save();
            return edmSchemaVersion;
        }
        return edmSchemaVersions[0];
    }

    private EdmSchemaVersion getSchemaVersionEntity() {
        EdmSchemaVersion[] edmSchemaVersion = (EdmSchemaVersion[])this.ao.find(EdmSchemaVersion.class);
        if (edmSchemaVersion.length == 0) {
            return null;
        }
        return edmSchemaVersion[0];
    }
}

