AJS.toInit(function () {
    $("#edm-progress-bar-wrapper").hide();
});

let edmResponseId = 0;

export function remoteAbstractTask(url, onSuccess, onError){
    let $progress = $("#edm-progress-bar-wrapper");
    let $progressText = $("#edm-progress-bar-text");
    $progress.show(200, () => {
        AJS.progressBars.update("#edm-updating-progress", 0);
    });

    $.ajax({
        url: url,
        dataType: 'json'
    }).done(resp => {
        let taskId = resp.taskId;
        edmResponseId = resp.responseId;
        queryUpdate(taskId, 0);
    }).fail((resp) => {
        handleFail(resp);
    });

    function queryUpdate(taskId, counter) {
        $.get(`${Confluence.getContextPath()}/rest/api/longtask/${taskId}`)
            .done(resp => handleQueryUpdate(resp, taskId, counter))
            .fail((wtf) => handleFail(wtf));
    }

    function handleQueryUpdate(resp, taskId, counter) {
        if (resp.percentageComplete === 100) {
            if(counter > 10){
                handleCompleted(resp);
            } else {
                routine(resp, taskId, counter + 1);
            }
        } else {
            routine(resp, taskId, counter);
        }
    }

    function routine(resp, taskId, counter){
        updateProgress({
            message: resp.messages[0].translation,
            percentage: resp.percentageComplete
        });
        setTimeout(() => queryUpdate(taskId, counter), 100);
    }

    function handleFail(fail){
        console.log("failed");
    }

    function handleCompleted(resp){
        console.log("handle complete");
        updateProgress({
            message: resp.messages[0].translation,
            percentage: 100
        });

        $.get(`${Confluence.getContextPath()}/rest/edm/1.0/completed/${edmResponseId}`)
            .done((resp) => onSuccess(resp));
    }

    function updateProgress({message, percentage}){
        let number = percentage / 100;
        AJS.progressBars.update("#edm-updating-progress", number);
        $progressText.text(message);
    }
}
