import {convertToStatusSelectObject} from "./edm-select2";
import {NOT_EDM_LOAD_SELECTOR} from "./EasyDropdownMenu";

const selectStatusOptionInDropdown = function (input, optionsList, selectedOptionId) {
    const currentStatusOption = optionsList.find(option => option.id === selectedOptionId);
    const data = currentStatusOption ?
        convertToStatusSelectObject([currentStatusOption])[0] :
        {id: selectedOptionId, text: "<span  class='aui-lozenge edm-aui-lozenge-blank'/>"};
    $(input).select2("data", data);
};

export const initStatusDropdowns = function (elementTarget) {
    setAllStatusDropdowns(elementTarget);
    addChangeEventListenersToStatusDropdowns(elementTarget);
    elementTarget.find("span#edm-select2-candidate").addClass("edm-load");
};

const setAllStatusDropdowns = function (elementTarget) {
    elementTarget.find("span#edm-select2-candidate" + NOT_EDM_LOAD_SELECTOR).each(function () {
        const optionsList = JSON.parse(this.getAttribute("data-optionsList"));
        const selectedOptionId = this.getAttribute("data-optionId");
        createStatusDropdown(this, optionsList, selectedOptionId);
    });
};

export function createStatusDropdown(input, optionsList, selectedOptionId) {
    AJS.$(input).select2({
        dropdownCssClass: "edm-status-dropdownClass",
        containerCssClass: "dropdowncontainer-css",
        dropdownAutoWidth: true,
        minimumResultsForSearch: Infinity,
        multiple: false,
        allowClear: true,
        data: convertToStatusSelectObject(optionsList),
        escapeMarkup: function (m) {
            return m;
        }
    });
    selectStatusOptionInDropdown(input, optionsList, selectedOptionId);
}

const saveOptions = function (data) {
    Edm.Rest.updatePredefinedMacro(data);
};

function getCurrentOptionValue(parsedOptionsList, optionId){
    for (const option of parsedOptionsList) {
        if (option.id === optionId) {
            return option.name;
        }
    }
    return "";
}

const addChangeEventListenersToStatusDropdowns = function (elementTarget) {

    elementTarget.find("span#edm-select2-candidate" + NOT_EDM_LOAD_SELECTOR).on("change", function () {
        const macroId = this.getAttribute("data-macroId");
        const optionsList = this.getAttribute("data-optionsList");
        const parsedOptionsList = JSON.parse(optionsList);
        const optionId = this.value;
        const pageId = this.getAttribute("data-pageId");
        const silentUpdate = this.getAttribute("data-silentUpdate");

        const data = {
            pageId: pageId,
            macroId: macroId,
            optionId: optionId,
            currentOptionValue: getCurrentOptionValue(parsedOptionsList, optionId),
            silentUpdate: silentUpdate
        };
        saveOptions(data);
    });
};
