/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import eps.focuspro.cql.FormatUtils;
import eps.focuspro.rest.dtos.DropdownSetId;
import eps.focuspro.rest.edmindexing.EdmReIndexer;
import eps.focuspro.rest.helper.ResourceContextBuilder;
import eps.focuspro.rest.helper.ResourcesRunner;
import eps.focuspro.search.PageSearcher;
import eps.focuspro.search.core.SearchResultProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/cql")
@Consumes(value={"application/json"})
@Produces(value={"text/html"})
public class RestCQLSearch {
    private final EdmReIndexer reindexer;
    private final SearchResultProvider searchResultProvider;
    private final PageSearcher pageSearcher;
    private final ResourcesRunner resourcesRunner;

    @Inject
    public RestCQLSearch(EdmReIndexer reindexer, SearchResultProvider searchResultProvider, PageSearcher pageSearcher, ResourcesRunner resourcesRunner) {
        this.reindexer = reindexer;
        this.searchResultProvider = searchResultProvider;
        this.pageSearcher = pageSearcher;
        this.resourcesRunner = resourcesRunner;
    }

    @AnonymousSiteAccess
    @POST
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    @Path(value="/search/allUsedDropdownSets/")
    public Response getPagesOfDropdownSet(DropdownSetId input) {
        return this.resourcesRunner.run(() -> {
            List<Map<String, String>> searchResultMap = this.getPageTitlesOfDropdownSet(input.setId.trim());
            return Response.ok((Object)new Gson().toJson(searchResultMap), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().build());
    }

    @AnonymousSiteAccess
    @GET
    @Produces(value={"application/json"})
    @Path(value="/search/getPagesOfSet/")
    @ReadOnlyAccessBlocked
    public Response getAutoFillStatus(@QueryParam(value="query") String query) {
        return this.resourcesRunner.run(() -> {
            DropDownSearchTerm statusOptionSearchTerm = this.getSearchTermsForEdmFilter(query, "EdmStatusOption");
            return Response.ok((Object)new Gson().toJson((Object)statusOptionSearchTerm), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().build());
    }

    @AnonymousSiteAccess
    @GET
    @Produces(value={"application/json"})
    @Path(value="/search/set-id/reindex/")
    @ReadOnlyAccessBlocked
    public Response reindexMacrosFromSetId(@QueryParam(value="query") String query) {
        return this.resourcesRunner.run(() -> {
            this.reindexer.reIndexSetIds(query);
            return Response.ok((Object)"hello", (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().build());
    }

    @AnonymousSiteAccess
    @GET
    @Produces(value={"application/json"})
    @Path(value="/search/allUsedDropdowns/")
    @ReadOnlyAccessBlocked
    public Response getAutoFillDropdown(@QueryParam(value="query") String query) {
        return this.resourcesRunner.run(() -> {
            DropDownSearchTerm dropDownSearchTerm = this.getSearchTermsForEdmFilter(query, "EdmOption");
            return Response.ok((Object)new Gson().toJson((Object)dropDownSearchTerm), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }, new ResourceContextBuilder().build());
    }

    private List<Map<String, String>> getPageTitlesOfDropdownSet(String setId) {
        ArrayList<Map<String, String>> titlesList = new ArrayList<Map<String, String>>();
        List<Page> list = this.pageSearcher.getPagesForSetId(setId);
        for (Page page : list) {
            titlesList.add(this.getMapOfPage(page));
        }
        return titlesList;
    }

    private Map<String, String> getMapOfPage(Page page) {
        HashMap<String, String> searchMap = new HashMap<String, String>();
        searchMap.put("title", page.getDisplayTitle());
        searchMap.put("url", page.getUrlPath());
        return searchMap;
    }

    private DropDownSearchTerm getSearchTermsForEdmFilter(String query, String indexableProperty) {
        DropDownSearchTerm dropDownSearchTerm = new DropDownSearchTerm();
        Set<String> fieldValues = this.getUsedFieldValuesBySearch(indexableProperty);
        if (query.length() <= 1) {
            dropDownSearchTerm.addListOfOptions(this.getAllFieldValuesPLUSOldQuery(fieldValues, ""));
        } else if (query.contains("&&")) {
            dropDownSearchTerm.addListOfOptions(this.getAllOptionsContainingQueryMergedToOldQuery(fieldValues, query));
        } else {
            dropDownSearchTerm.addListOfOptions(this.getAllFieldValuesContaingQuery(fieldValues, query));
        }
        return dropDownSearchTerm;
    }

    private Set<String> getUsedFieldValuesBySearch(String fieldName) {
        HashSet<String> fieldValues = new HashSet<String>();
        List<SearchResult> list = this.searchResultProvider.searchFieldName(fieldName);
        for (SearchResult searchResult : list) {
            Set fields = searchResult.getFieldValues(fieldName);
            if (fields == null) continue;
            fieldValues.addAll(fields);
        }
        return fieldValues;
    }

    private List<Option> getAllFieldValuesPLUSOldQuery(Set<String> fieldValues, String oldQuery) {
        ArrayList<Option> optionList = new ArrayList<Option>();
        for (String fieldValue : fieldValues) {
            StringJoiner stringJoiner = new StringJoiner("");
            if (!oldQuery.isEmpty()) {
                stringJoiner.add(oldQuery);
            }
            stringJoiner.add(fieldValue);
            optionList.add(this.getSelect2ResponseOptionFromFieldValue(stringJoiner.toString()));
        }
        return optionList;
    }

    private List<Option> getAllOptionsContainingQueryMergedToOldQuery(Set<String> fieldValues, String query) {
        ArrayList<Option> optionList = new ArrayList<Option>();
        int lastIndexOfAND = query.lastIndexOf("&");
        String newQuery = "";
        String oldQuery = query;
        if (query.length() > lastIndexOfAND - 1) {
            oldQuery = query.substring(0, lastIndexOfAND + 1);
            newQuery = query.substring(lastIndexOfAND + 1);
        }
        if (!newQuery.isEmpty()) {
            optionList.addAll(this.generateListOfAllMapsIncludingANDPlusNewQuery(fieldValues, newQuery, oldQuery));
        } else {
            optionList.addAll(this.getAllFieldValuesPLUSOldQuery(fieldValues, oldQuery));
        }
        return optionList;
    }

    private List<Option> generateListOfAllMapsIncludingANDPlusNewQuery(Set<String> fieldValues, String newQuery, String oldQuery) {
        ArrayList<Option> options = new ArrayList<Option>();
        for (String fieldValue : fieldValues) {
            if (!fieldValue.contains(newQuery)) continue;
            StringJoiner stringJoiner = new StringJoiner("");
            stringJoiner.add(oldQuery);
            stringJoiner.add(fieldValue);
            options.add(this.getSelect2ResponseOptionFromFieldValue(stringJoiner.toString()));
        }
        return options;
    }

    private List<Option> getAllFieldValuesContaingQuery(Set<String> fieldValues, String query) {
        ArrayList<Option> options = new ArrayList<Option>();
        for (String fieldValue : fieldValues) {
            String[] fieldDescriptorText = fieldValue.split(" :");
            if (fieldDescriptorText.length <= 1 || !fieldDescriptorText[1].contains(query)) continue;
            options.add(this.getSelect2ResponseOptionFromFieldValue(fieldValue));
        }
        return options;
    }

    private Option getSelect2ResponseOptionFromFieldValue(String fieldValue) {
        String text = FormatUtils.decodeFromBase64(fieldValue);
        return new Option(text, text);
    }

    private class DropDownSearchTerm {
        @JsonProperty
        List<Option> searchResults = new ArrayList<Option>();
        @JsonProperty
        List suggestedResults = new ArrayList();

        private DropDownSearchTerm() {
        }

        public void addListOfOptions(List<Option> options) {
            this.searchResults.addAll(options);
        }
    }

    private class Option {
        @JsonProperty
        private String id;
        @JsonProperty
        private String text;

        private Option(String id, String text) {
            this.id = id;
            this.text = text;
        }
    }
}

