/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.migration.macroMigration;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.mail.notification.ConversionContextCreator;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import eps.focuspro.migration.macroMigration.EDMMacroSchemaMigrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaVersion1Updater {
    private final PageManager pageManager;
    private ConversionContextCreator conversionContextCreator;
    private final XhtmlContent xhtmlContent;
    private final EDMMacroSchemaMigrator edmMacroSchemaMigrator;
    private static final Logger log = LoggerFactory.getLogger(SchemaVersion1Updater.class);
    private boolean isPageModified = false;

    public SchemaVersion1Updater(PageManager pageManager, XhtmlContent xhtmlContent, EDMMacroSchemaMigrator edmMacroSchemaMigrator) {
        this.pageManager = pageManager;
        this.edmMacroSchemaMigrator = edmMacroSchemaMigrator;
        this.conversionContextCreator = new ConversionContextCreator();
        this.xhtmlContent = xhtmlContent;
    }

    public long migratePage(Page page) {
        if (!page.isDraft() && page.isCurrent()) {
            try {
                this.isPageModified = false;
                ConversionContext conversionContext = this.getConversionContext((ContentEntityObject)page);
                String oldPageBody = page.getBodyAsString();
                String updatedPageBody = this.xhtmlContent.updateMacroDefinitions(oldPageBody, conversionContext, this.getEdmMacroUpdater(conversionContext));
                if (!oldPageBody.equals(updatedPageBody) && page.isPersistent() && this.isPageModified) {
                    log.warn("Updating page: " + page.getDisplayTitle());
                    this.pageManager.saveNewVersion((ContentEntityObject)page, newPage -> newPage.setBodyAsString(updatedPageBody), DefaultSaveContext.MINOR_EDIT);
                    return page.getId();
                }
            }
            catch (Exception e) {
                log.warn("Updating Edm Macros threw an exception on page: " + page.getDisplayTitle() + " with id: " + page.getIdAsString(), (Throwable)e);
            }
        }
        return 0L;
    }

    private MacroDefinitionUpdater getEdmMacroUpdater(ConversionContext conversionContext) {
        return macroDefinition -> {
            String macroName = macroDefinition.getName();
            if (("easy-dropdown-menu-edit-mode".equals(macroName) || "easy-dropdown-menu-status".equals(macroName) || "easy-dropdown-menu-predefined".equals(macroName)) && macroDefinition.getSchemaVersion() < 2) {
                this.isPageModified = true;
                macroDefinition = this.edmMacroSchemaMigrator.migrateEdmMacro(macroDefinition, conversionContext);
            }
            return macroDefinition;
        };
    }

    private ConversionContext getConversionContext(ContentEntityObject contentEntityObject) {
        return this.conversionContextCreator.createConversionContext(contentEntityObject);
    }
}

