/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.history.service;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Option;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.history.historyObjects.OptionHistoryChange;
import eps.focuspro.history.historyObjects.SetHistory;
import eps.focuspro.history.service.SetHistoryUpdater;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class HistoryService<T extends Option> {
    private final SetHistoryUpdater<T> setHistoryUpdater;

    public HistoryService(SetHistoryUpdater<T> setHistoryUpdater) {
        this.setHistoryUpdater = setHistoryUpdater;
    }

    public SetHistory<T> createHistory(@Nullable SetHistory<T> oldSetHistory, DropdownSet<T> newDropdownSet, @Nullable DropdownSet<T> oldDropdownSet) {
        String setId = newDropdownSet.getId();
        String dateTime = new DateTime().toString("MM/dd/yyyy HH:mm:ss");
        String user = this.getUsername();
        List<Object> oldOptionsList = new ArrayList();
        if (oldDropdownSet != null) {
            oldOptionsList = oldDropdownSet.getOptionsList();
        }
        List<T> newOptionsList = newDropdownSet.getOptionsList();
        List addedOptions = this.detectNewOptions(oldOptionsList, newOptionsList);
        List deletedOptions = this.detectDeletedOptions(oldOptionsList, newOptionsList);
        Map changedOptions = this.detectChangedOptions(oldOptionsList, newOptionsList);
        ArrayList optionHistoryChanges = new ArrayList(this.getAddedOptionsHistoryChanges(addedOptions, dateTime, user));
        optionHistoryChanges.addAll(this.getDeletedOptionsHistoryChanges(deletedOptions, dateTime, user));
        optionHistoryChanges.addAll(this.getChangedOptionsHistoryChanges(changedOptions, dateTime, user));
        if (!optionHistoryChanges.isEmpty()) {
            return this.setHistoryUpdater.updateSetHistory(oldSetHistory, optionHistoryChanges, setId);
        }
        if (oldSetHistory == null) {
            return this.setHistoryUpdater.updateSetHistory(null, new ArrayList(), setId);
        }
        return null;
    }

    private String getUsername() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return confluenceUser.getName();
    }

    private List<T> detectNewOptions(List<T> oldOptionsList, List<T> newOptionsList) {
        List<String> listOfOldIds = this.getOptionIdsList(oldOptionsList);
        return this.getAllOptionsNotContainedInIdList(listOfOldIds, newOptionsList);
    }

    private List<T> detectDeletedOptions(List<T> oldOptionsList, List<T> newOptionsList) {
        List<String> listOfNewIds = this.getOptionIdsList(newOptionsList);
        return this.getAllOptionsNotContainedInIdList(listOfNewIds, oldOptionsList);
    }

    private Map<T, T> detectChangedOptions(List<T> oldOptionsList, List<T> newOptionsList) {
        List<String> listOfNewIds = this.getOptionIdsList(newOptionsList);
        List<T> reducedOptionsList = this.getAllOptionsContainedInIdList(listOfNewIds, oldOptionsList);
        Map<T, T> optionsMapping = this.mapOptionsTogetherWithId(reducedOptionsList, newOptionsList);
        return optionsMapping.entrySet().stream().filter(entry -> {
            if (entry.getKey() instanceof LozengeOption) {
                LozengeOption oldOption = (LozengeOption)entry.getKey();
                LozengeOption newOption = (LozengeOption)entry.getValue();
                return !oldOption.getColor().equals(newOption.getColor()) || !((Option)entry.getKey()).getName().equals(((Option)entry.getValue()).getName()) || !oldOption.getSubtle() == newOption.getSubtle() || !oldOption.getTextColor() == newOption.getTextColor();
            }
            return !((Option)entry.getKey()).getName().equals(((Option)entry.getValue()).getName());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<T, T> mapOptionsTogetherWithId(List<T> reducedOptionsList, List<T> newOptionsList) {
        return reducedOptionsList.stream().collect(Collectors.toMap(oldOption -> oldOption, oldOption -> this.getLozengeOptionWithId(oldOption.getId(), newOptionsList)));
    }

    private T getLozengeOptionWithId(String id, List<T> optionsList) {
        return (T)((Option)optionsList.stream().filter(newOption -> id.equals(newOption.getId())).findFirst().orElse(null));
    }

    private List<String> getOptionIdsList(List<T> optionsList) {
        return optionsList.stream().map(option -> option.getId().trim()).collect(Collectors.toList());
    }

    private List<T> getAllOptionsNotContainedInIdList(List<String> optionIdList, List<T> optionsList) {
        return optionsList.stream().filter(lozengeOption -> !optionIdList.contains(lozengeOption.getId().trim())).collect(Collectors.toList());
    }

    private List<T> getAllOptionsContainedInIdList(List<String> optionIdList, List<T> optionsList) {
        return optionsList.stream().filter(lozengeOption -> optionIdList.contains(lozengeOption.getId())).collect(Collectors.toList());
    }

    private List<OptionHistoryChange<T>> getAddedOptionsHistoryChanges(List<T> addedOptions, String dateTime, String user) {
        ArrayList<OptionHistoryChange<T>> optionHistoryChangeList = new ArrayList<OptionHistoryChange<T>>();
        for (Option option : addedOptions) {
            optionHistoryChangeList.add(new OptionHistoryChange<Option>(option, option, dateTime, user, OptionHistoryChange.HistoryEvent.NEW));
        }
        return optionHistoryChangeList;
    }

    private List<OptionHistoryChange<T>> getDeletedOptionsHistoryChanges(List<T> deletedOptions, String dateTime, String user) {
        ArrayList<OptionHistoryChange<T>> optionHistoryChangeList = new ArrayList<OptionHistoryChange<T>>();
        for (Option option : deletedOptions) {
            optionHistoryChangeList.add(new OptionHistoryChange<Option>(option, option, dateTime, user, OptionHistoryChange.HistoryEvent.DELETED));
        }
        return optionHistoryChangeList;
    }

    private List<OptionHistoryChange<T>> getChangedOptionsHistoryChanges(Map<T, T> changedOptionsMap, String dateTime, String user) {
        ArrayList optionHistoryChangeList = new ArrayList();
        changedOptionsMap.forEach((key, value) -> optionHistoryChangeList.add(new OptionHistoryChange<Option>((Option)key, (Option)value, dateTime, user, OptionHistoryChange.HistoryEvent.CHANGED)));
        return optionHistoryChangeList;
    }

    public SetHistory<T> updateSetHistoryWithRestoredItem(SetHistory<T> oldSetHistory, T newOption) {
        String dateTime = new DateTime().toString("MM/dd/yyyy HH:mm:ss");
        String user = this.getUsername();
        List<OptionHistoryChange<T>> historyList = oldSetHistory.getHistoryList();
        historyList.add(new OptionHistoryChange<T>(newOption, newOption, dateTime, user, OptionHistoryChange.HistoryEvent.RESTORED));
        return new SetHistory<T>(oldSetHistory.getSetId(), historyList);
    }
}

