/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.fix;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Option;
import eps.focuspro.fix.IdMapper;
import eps.focuspro.fix.ResolveInstantiation;
import eps.focuspro.fix.helper.MainSetDecider;
import eps.focuspro.search.PageSearcher;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicationAnalyzer {
    private MainSetDecider mainSetDecider;
    private IdMapper idMapper;
    private PageSearcher pageSearcher;
    private static final Logger log = LoggerFactory.getLogger(DuplicationAnalyzer.class);

    public DuplicationAnalyzer(MainSetDecider mainSetDecider, IdMapper idMapper, PageSearcher pageSearcher) {
        this.mainSetDecider = mainSetDecider;
        this.idMapper = idMapper;
        this.pageSearcher = pageSearcher;
    }

    public <T extends Option> ResolveInstantiation<T> createUpdateInstantiation(List<DropdownSet<T>> sets) {
        DropdownSet mainSet = this.mainSetDecider.getMainSet(sets);
        log.info("The main set is the set with the id:" + mainSet.getId());
        sets.removeIf(set -> set.getId().equals(mainSet.getId()));
        Map<String, Set<String>> affectedPages = this.getAffectedPages(sets);
        Map<String, String> setMapping = this.idMapper.createSetMapping(mainSet, sets);
        Map<String, String> optionsMapping = this.idMapper.createOptionsMapping(mainSet, sets);
        return new ResolveInstantiation<T>(affectedPages, setMapping, optionsMapping, mainSet, sets);
    }

    private <T extends Option> Map<String, Set<String>> getAffectedPages(List<DropdownSet<T>> sets) {
        Set<String> setIds = this.getSetIds(sets);
        return this.pageSearcher.getPagesMappingForSetIds(setIds);
    }

    private <T extends Option> Set<String> getSetIds(List<DropdownSet<T>> sets) {
        HashSet<String> ids = new HashSet<String>();
        sets.forEach(set -> ids.add(set.getId()));
        return ids;
    }
}

