/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence.config.daos;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSpaceSettings;
import eps.focuspro.edm.persistence.config.migration.OnTheFlyMigrator;
import eps.focuspro.edm.persistence.entities.CssClass;
import eps.focuspro.edm.persistence.entities.EdmConfig;
import eps.focuspro.edm.persistence.entities.PermittedGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdmConfigDao {
    private final ActiveObjects ao;
    private final OnTheFlyMigrator onTheFlyMigrator;
    private static final Logger log = LoggerFactory.getLogger(EdmConfigDao.class);
    private final TransactionTemplate transactionTemplate;

    public EdmConfigDao(ActiveObjects ao, OnTheFlyMigrator onTheFlyMigrator, TransactionTemplate transactionTemplate) {
        this.ao = Objects.requireNonNull(ao);
        this.onTheFlyMigrator = onTheFlyMigrator;
        this.transactionTemplate = transactionTemplate;
    }

    public EdmGlobalSettings getGlobalSettings() {
        return (EdmGlobalSettings)this.transactionTemplate.execute(() -> {
            EdmConfig globalEntity = this.getConfigAndAssureConsistency(null);
            return this.mapGlobalSettings(globalEntity);
        });
    }

    public EdmSpaceSettings getSpaceSettings(String spaceKey) {
        return (EdmSpaceSettings)this.transactionTemplate.execute(() -> {
            EdmConfig edmConfig = this.getConfigAndAssureConsistency(spaceKey);
            return this.mapSpaceSettings(edmConfig);
        });
    }

    public void saveGlobalSettings(EdmGlobalSettings edmGlobalSettings) {
        this.transactionTemplate.execute(() -> {
            EdmConfig edmConfig = this.getConfigAndAssureConsistency(null);
            this.saveGlobalConfigInternal(edmConfig, edmGlobalSettings);
            return null;
        });
    }

    public void saveSpaceSettings(EdmSpaceSettings edmSpaceSettings) {
        this.transactionTemplate.execute(() -> {
            EdmConfig edmConfig = this.getConfigAndAssureConsistency(edmSpaceSettings.getSpaceKey());
            this.saveSpaceConfigInternal(edmConfig, edmSpaceSettings);
            return null;
        });
    }

    private EdmConfig getConfigAndAssureConsistency(String spaceKey) {
        EdmConfig[] edmConfigs = this.getConfigs(spaceKey);
        this.removeDuplicatedConfigEntries(edmConfigs, spaceKey);
        if (edmConfigs.length == 0) {
            if (spaceKey == null) {
                return this.recoverGlobalSettings();
            }
            return this.recoverSpaceSettings(spaceKey);
        }
        return edmConfigs[0];
    }

    private EdmConfig[] getConfigs(String spaceKey) {
        if (spaceKey == null) {
            return (EdmConfig[])this.ao.find(EdmConfig.class, Query.select().where("SPACE_KEY IS NULL or SPACE_KEY = ?", new Object[]{""}));
        }
        return (EdmConfig[])this.ao.find(EdmConfig.class, Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey}));
    }

    private EdmConfig recoverGlobalSettings() {
        EdmGlobalSettings globalSettings = this.onTheFlyMigrator.createGlobalSettings();
        if (globalSettings == null) {
            globalSettings = this.getDefaultGlobalSettings();
        }
        return this.saveGlobalConfigInternal((EdmConfig)this.ao.create(EdmConfig.class, new DBParam[0]), globalSettings);
    }

    private EdmConfig recoverSpaceSettings(String spaceKey) {
        EdmSpaceSettings spaceSettings = this.onTheFlyMigrator.migrateSpaceSettings(spaceKey);
        if (spaceSettings == null) {
            spaceSettings = new EdmSpaceSettings(spaceKey, new ArrayList<String>(), new ArrayList<String>());
        }
        return this.saveSpaceConfigInternal((EdmConfig)this.ao.create(EdmConfig.class, new DBParam[0]), spaceSettings);
    }

    private void removeDuplicatedConfigEntries(EdmConfig[] edmConfigs, String spaceKey) {
        if (edmConfigs.length > 1) {
            log.warn("Duplicated config found for space: '{}' (null = global) -> deleting duplicated entries", (Object)spaceKey);
            for (int i = 1; i < edmConfigs.length; ++i) {
                EdmConfig edmConfig = edmConfigs[i];
                this.deleteEdmConfig(edmConfig);
            }
        }
    }

    private EdmGlobalSettings mapGlobalSettings(EdmConfig edmConfig) {
        return new EdmGlobalSettings(edmConfig.getDefaultEditModeCssClass(), edmConfig.getDefNonPredefCssClass(), edmConfig.getDefaultPredefinedCssClass(), edmConfig.getIsSuppressNotifications(), edmConfig.getAllowAnon(), edmConfig.getAllowWithoutEditPermission(), this.sanitizedList(edmConfig.getCssClassArray(), CssClass::getCssClassValue), this.sanitizedList(edmConfig.getPermittedGroupArray(), PermittedGroup::getPermittedGroupValue));
    }

    private EdmSpaceSettings mapSpaceSettings(EdmConfig edmConfig) {
        return new EdmSpaceSettings(edmConfig.getSpaceKey(), this.sanitizedList(edmConfig.getCssClassArray(), CssClass::getCssClassValue), this.sanitizedList(edmConfig.getPermittedGroupArray(), PermittedGroup::getPermittedGroupValue));
    }

    private <T> List<String> sanitizedList(T[] entities, Function<T, String> extractor) {
        return Arrays.stream(entities).map(extractor).map(value -> value == null ? "" : value).collect(Collectors.toList());
    }

    private void deleteEdmConfig(EdmConfig edmConfig) {
        for (CssClass cssClass : edmConfig.getCssClassArray()) {
            this.ao.delete(new RawEntity[]{this.ao.get(CssClass.class, (Object)cssClass.getID())});
        }
        for (PermittedGroup permittedGroup : edmConfig.getPermittedGroupArray()) {
            this.ao.delete(new RawEntity[]{this.ao.get(PermittedGroup.class, (Object)permittedGroup.getID())});
        }
        this.ao.delete(new RawEntity[]{this.ao.get(EdmConfig.class, (Object)edmConfig.getID())});
    }

    private EdmConfig saveGlobalConfigInternal(EdmConfig edmConfig, EdmGlobalSettings settings) {
        this.saveCssClasses(edmConfig, settings.getCssClasses());
        this.savePermittedGroups(edmConfig, settings.getPermittedGroups());
        edmConfig.setSpaceKey("");
        edmConfig.setDefaultEditModeCssClass(settings.getDefaultEditModeCssClass());
        edmConfig.setDefNonPredefCssClass(settings.getDefaultNonPredefinedCssClass());
        edmConfig.setDefaultPredefinedCssClass(settings.getDefaultPredefinedCssClass());
        edmConfig.setIsSuppressNotifications(settings.isSuppressNotifications());
        edmConfig.setAllowAnon(settings.isAllowAnonymous());
        edmConfig.setAllowWithoutEditPermission(settings.isAllowWithoutEditPermission());
        edmConfig.save();
        return edmConfig;
    }

    private EdmConfig saveSpaceConfigInternal(EdmConfig edmConfig, EdmSpaceSettings settings) {
        this.saveCssClasses(edmConfig, settings.getCssClasses());
        this.savePermittedGroups(edmConfig, settings.getPermittedGroups());
        edmConfig.setSpaceKey(settings.getSpaceKey());
        edmConfig.save();
        return edmConfig;
    }

    private void saveCssClasses(EdmConfig edmConfig, List<String> classNames) {
        Entity[] persistedClasses = edmConfig.getCssClassArray();
        this.updateFields(persistedClasses, classNames, CssClass::getCssClassValue, value -> this.addCssClass(edmConfig, (String)value));
    }

    private void savePermittedGroups(EdmConfig edmConfig, List<String> permittedGroupNames) {
        Entity[] persistedGroups = edmConfig.getPermittedGroupArray();
        this.updateFields(persistedGroups, permittedGroupNames, PermittedGroup::getPermittedGroupValue, value -> this.addPermittedGroup(edmConfig, (String)value));
    }

    private <T extends Entity> void updateFields(T[] persistedFields, List<String> newValues, Function<T, String> extractor, Consumer<String> creator) {
        List persistedValues = Arrays.stream(persistedFields).map(extractor).collect(Collectors.toList());
        for (String newValue : newValues) {
            if (persistedValues.contains(newValue)) continue;
            creator.accept(newValue);
        }
        for (T entity : persistedFields) {
            if (newValues.contains(extractor.apply(entity))) continue;
            this.ao.delete(new RawEntity[]{entity});
        }
    }

    private void addPermittedGroup(EdmConfig edmConfig, String groupName) {
        PermittedGroup permittedGroup = (PermittedGroup)this.ao.create(PermittedGroup.class, new DBParam[0]);
        permittedGroup.setEdmConfig(edmConfig);
        permittedGroup.setPermittedGroupValue(groupName);
        permittedGroup.save();
    }

    private void addCssClass(EdmConfig edmConfig, String className) {
        CssClass toAdd = (CssClass)this.ao.create(CssClass.class, new DBParam[0]);
        toAdd.setCssClassValue(className);
        toAdd.setEdmConfig(edmConfig);
        toAdd.save();
    }

    private EdmGlobalSettings getDefaultGlobalSettings() {
        return new EdmGlobalSettings("", "", "", false, false, false, new ArrayList<String>(), new ArrayList<String>());
    }
}

