/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.edm.persistence.config;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import eps.focuspro.edm.persistence.config.EdmGlobalSettings;
import eps.focuspro.edm.persistence.config.EdmSpaceSettings;
import eps.focuspro.edm.persistence.config.daos.EdmConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdmSettingsManager {
    private final EdmConfigDao edmConfigDao;
    private static final Logger log = LoggerFactory.getLogger(EdmSettingsManager.class);
    private final AccessModeService accessModeService;

    public EdmSettingsManager(EdmConfigDao edmConfigDao, AccessModeService accessModeService) {
        this.edmConfigDao = edmConfigDao;
        this.accessModeService = accessModeService;
    }

    public EdmGlobalSettings getGlobalSettings() {
        return this.edmConfigDao.getGlobalSettings();
    }

    public EdmSpaceSettings getSpaceSettings(String spaceKey) {
        return this.edmConfigDao.getSpaceSettings(spaceKey);
    }

    public void saveSpaceSettings(EdmSpaceSettings edmSpaceSettings) {
        this.safeUpdate(() -> this.edmConfigDao.saveSpaceSettings(edmSpaceSettings), "Error updating EDM Space Config, space key: " + edmSpaceSettings.getSpaceKey());
    }

    public void saveGlobalSettings(EdmGlobalSettings edmGlobalSettings) {
        this.safeUpdate(() -> this.edmConfigDao.saveGlobalSettings(edmGlobalSettings), "Error updating EDM Global Config");
    }

    private void safeUpdate(Runnable runnable, String errorMessage) {
        this.verifyReadOnlyMode();
        try {
            runnable.run();
        }
        catch (Exception e) {
            log.error(errorMessage, (Throwable)e);
        }
    }

    private void verifyReadOnlyMode() {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            log.warn("Couldn't save space settings because read-only mode is active");
            throw new IllegalStateException("Cannot execute modifying database access in readonly mode.");
        }
    }
}

