/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.cql;

import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.configui.OptionCalculator;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MacroValuesProvider {
    private final OptionCalculator optionCalculator = new OptionCalculator();
    private final SetEntityAccessor setEntityAccessor;

    public MacroValuesProvider(SetEntityAccessor setEntityAccessor) {
        this.setEntityAccessor = setEntityAccessor;
    }

    public String getCurrentOptionFromStatusMacro(String setId, String currentOptionId) {
        LozengeOption chosenOption;
        DropdownSet<LozengeOption> chosenLozengeSet;
        if (!currentOptionId.isEmpty() && !setId.isEmpty() && (chosenLozengeSet = this.setEntityAccessor.getLozengeSet(setId)) != null && (chosenOption = this.optionCalculator.getLozengeOption(chosenLozengeSet, currentOptionId)) != null) {
            return chosenOption.getName();
        }
        return null;
    }

    public List<String> getCurrentOptionListFromTextMacro(String setId, List<String> optionIdList) {
        ArrayList<String> currentOptionListToSend = new ArrayList<String>();
        DropdownSet<TextOption> dropdownSet = this.setEntityAccessor.getTextSet(setId);
        if (dropdownSet != null) {
            List<TextOption> textOptions = this.optionCalculator.getTextOptions(dropdownSet, optionIdList);
            for (TextOption textOption : textOptions) {
                currentOptionListToSend.add(textOption.getName());
            }
        }
        return currentOptionListToSend;
    }

    public List<String> getCurrentOptionListFromNonPredefinedMacro(Map<String, String> parameters) {
        if (parameters.containsKey("current-option")) {
            String currentOptionString = parameters.get("current-option");
            return Arrays.asList(currentOptionString.split("\\s*,\\s*"));
        }
        return new ArrayList<String>();
    }

    public List<String> getCurrentOptionIdsFromText(Map<String, String> parameters) {
        ArrayList<String> optionIdList = new ArrayList<String>();
        if (parameters.containsKey("option-id")) {
            String currentOptionIdList = parameters.get("option-id");
            optionIdList = new ArrayList<String>(Arrays.asList(currentOptionIdList.split("\\s*,\\s*")));
        }
        return optionIdList;
    }

    public String getCurrentOptionIdFromStatus(Map<String, String> parameters) {
        if (parameters.containsKey("option-id")) {
            return parameters.get("option-id").trim();
        }
        return "";
    }

    public String getUniversalSetId(Map<String, String> parameters) {
        if (parameters.containsKey("set-id")) {
            return parameters.get("set-id").trim();
        }
        return "";
    }
}

