/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.cql;

import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import eps.focuspro.cql.FormatUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FieldCreator {
    public List<FieldDescriptor> createFullOptionDescriptors(List<String> options, String indexableProperty, String pageProperty) {
        return options.stream().filter(option -> !StringUtils.isBlank((CharSequence)option)).map(option -> {
            String formattedOption = !StringUtils.isBlank((CharSequence)pageProperty) ? FormatUtils.getColonSeparatedValue(pageProperty, option) : option;
            String id = FormatUtils.encodeToBase64(formattedOption);
            return new FieldDescriptor(indexableProperty, id, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED);
        }).collect(Collectors.toList());
    }

    public List<FieldDescriptor> createSetAndOptionIdDescriptors(String setId, List<String> optionIds) {
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        if (!setId.isEmpty()) {
            fieldDescriptors.add(this.createSetIdFieldDescriptor(setId));
        }
        for (String optionId : optionIds) {
            if (optionId == null || optionId.isEmpty()) continue;
            fieldDescriptors.add(this.createOptionIdFieldDescriptor(optionId));
        }
        return fieldDescriptors;
    }

    private FieldDescriptor createSetIdFieldDescriptor(String setId) {
        return new FieldDescriptor("EdmSetId", setId, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED);
    }

    private FieldDescriptor createOptionIdFieldDescriptor(String optionId) {
        return new FieldDescriptor("EdmOptionId", optionId, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED);
    }
}

