/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.cql;

import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchSortWrapper;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.EqualityFieldHandler;
import com.atlassian.querylang.fields.TextFieldHandler;
import com.atlassian.querylang.fields.expressiondata.BaseExpressionData;
import com.atlassian.querylang.fields.expressiondata.EqualityExpressionData;
import com.atlassian.querylang.fields.expressiondata.ExpressionData;
import com.atlassian.querylang.fields.expressiondata.SetExpressionData;
import com.atlassian.querylang.fields.expressiondata.TextExpressionData;
import com.atlassian.querylang.query.FieldOrder;
import com.atlassian.querylang.query.OrderDirection;
import eps.focuspro.cql.FormatUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EdmFieldHandler
extends BaseFieldHandler
implements TextFieldHandler<V2SearchQueryWrapper>,
EqualityFieldHandler<String, V2SearchQueryWrapper> {
    private static final String STATUS_FIELD_NAME = "EdmStatusOption";
    private static final String OPTION_FIELD_NAME = "EdmOption";
    public static final String AND_OPERATOR = "&&";
    public static final String AND_OPERATOR2 = " and ";
    public static final String PLUS = "+";
    public static final String WHITESPACE = " ";

    public EdmFieldHandler() {
        super(STATUS_FIELD_NAME, true);
    }

    public FieldOrder buildOrder(OrderDirection direction) {
        return new V2SearchSortWrapper((SearchSort)new TitleSort(V2SearchSortWrapper.convertOrder((OrderDirection)direction)));
    }

    public V2SearchQueryWrapper build(SetExpressionData expressionData, Iterable<String> values) {
        this.validateSupportedOp((Enum)((SetExpressionData.Operator)expressionData.getOperator()), new HashSet<SetExpressionData.Operator>(Arrays.asList(SetExpressionData.Operator.IN, SetExpressionData.Operator.NOT_IN)));
        SearchQuery query = V2FieldHandlerHelper.joinSingleValueSearchQueries(values, value -> this.createEqualityQuery((String)value, (BaseExpressionData)expressionData));
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)query, (ExpressionData)expressionData);
    }

    public V2SearchQueryWrapper build(TextExpressionData expressionData, String value) {
        this.validateSupportedOp((Enum)((TextExpressionData.Operator)expressionData.getOperator()), new HashSet<TextExpressionData.Operator>(Arrays.asList(TextExpressionData.Operator.CONTAINS, TextExpressionData.Operator.NOT_CONTAINS)));
        String fieldName = expressionData.getFieldName().equals("EdmDropdown") ? OPTION_FIELD_NAME : STATUS_FIELD_NAME;
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)new TextFieldQuery(fieldName, value, BooleanOperator.AND), (ExpressionData)expressionData);
    }

    public V2SearchQueryWrapper build(EqualityExpressionData expressionData, String searchTerm) {
        this.validateSupportedOp((Enum)((EqualityExpressionData.Operator)expressionData.getOperator()), new HashSet<EqualityExpressionData.Operator>(Arrays.asList(EqualityExpressionData.Operator.EQUALS, EqualityExpressionData.Operator.NOT_EQUALS)));
        SearchQuery query = this.getSearchQuery(searchTerm, expressionData);
        if (searchTerm.contains(PLUS)) {
            query = this.createOrQueryWithoutPlus(expressionData, searchTerm, query);
        }
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)query, (ExpressionData)expressionData);
    }

    private SearchQuery getSearchQuery(String searchTerm, EqualityExpressionData expressionData) {
        return searchTerm.contains(AND_OPERATOR) || searchTerm.contains(AND_OPERATOR2) ? this.getAndQuery(searchTerm, (BaseExpressionData)expressionData) : this.createEqualityQuery(searchTerm, (BaseExpressionData)expressionData);
    }

    private TermQuery createEqualityQuery(String searchTerm, BaseExpressionData expressionData) {
        String fieldName = expressionData.getFieldName().equals("EdmDropdown") ? OPTION_FIELD_NAME : STATUS_FIELD_NAME;
        return new TermQuery(fieldName, FormatUtils.encodeToBase64(searchTerm));
    }

    private SearchQuery getAndQuery(String searchTerm, BaseExpressionData expressionData) {
        List<String> splitAndValues = Arrays.asList(searchTerm.split(searchTerm.contains(AND_OPERATOR) ? AND_OPERATOR : AND_OPERATOR2));
        Set immutableQuerySet = splitAndValues.stream().map(value -> this.createEqualityQuery((String)value, expressionData)).collect(Collectors.toUnmodifiableSet());
        return BooleanQuery.composeAndQuery(immutableQuerySet);
    }

    private SearchQuery createOrQueryWithoutPlus(EqualityExpressionData expressionData, String searchTerm, SearchQuery query) {
        String searchTermWithoutPlus = searchTerm.replace(PLUS, WHITESPACE);
        SearchQuery equalityQuery = this.getSearchQuery(searchTermWithoutPlus, expressionData);
        return BooleanQuery.composeOrQuery(Set.of(query, equalityQuery).stream().collect(Collectors.toUnmodifiableSet()));
    }
}

