/*
 * Decompiled with CFR 0.152.
 */
package eps.focuspro.configui.spaceconfig;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import eps.focuspro.DropdownSet.DropdownSet;
import eps.focuspro.DropdownSet.Options.LozengeOption;
import eps.focuspro.DropdownSet.Options.TextOption;
import eps.focuspro.edm.persistence.MigratorGeneral;
import eps.focuspro.edm.persistence.SetEntityAccessor;
import eps.focuspro.edm.persistence.config.EdmSettingsManager;
import eps.focuspro.edm.persistence.config.EdmSpaceSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceConfigServlet
extends HttpServlet {
    private final transient SoyTemplateRenderer soyRenderer;
    private transient List<DropdownSet<LozengeOption>> lozengeSets;
    private List<String> groups;
    private transient List<DropdownSet<TextOption>> textSets;
    private List<String> cssClasses;
    private final transient SetEntityAccessor setEntityAccessor;
    private final transient EdmSettingsManager edmSettingsManager;
    private final MigratorGeneral migratorGeneral;
    private final AccessModeService accessModeService;
    private boolean isReadOnlyModeActive;
    private final SettingsManager settingsManager;
    private String baseUrl;
    private static final String SPACE_KEY = "spaceKey";
    private static final String SPACE_ID = "spaceId";
    private static final Logger log = LoggerFactory.getLogger(SpaceConfigServlet.class);

    public SpaceConfigServlet(SoyTemplateRenderer soyTemplateRenderer, SetEntityAccessor setEntityAccessor, EdmSettingsManager edmSettingsManager, MigratorGeneral migratorGeneral, AccessModeService accessModeService, SettingsManager settingsManager) {
        this.soyRenderer = soyTemplateRenderer;
        this.setEntityAccessor = setEntityAccessor;
        this.edmSettingsManager = edmSettingsManager;
        this.migratorGeneral = migratorGeneral;
        this.accessModeService = accessModeService;
        this.settingsManager = settingsManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.migratorGeneral.check();
        String spaceKey = req.getParameter(SPACE_KEY);
        long spaceId = Long.parseLong(req.getParameter(SPACE_ID));
        EdmSpaceSettings spaceSettings = this.edmSettingsManager.getSpaceSettings(spaceKey);
        this.cssClasses = spaceSettings.getCssClasses();
        this.lozengeSets = this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(spaceKey) == null ? new ArrayList() : this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(spaceKey);
        this.groups = spaceSettings.getPermittedGroups();
        this.textSets = this.setEntityAccessor.getLozengeSetsSpaceOrGlobal(spaceKey) == null ? new ArrayList() : this.setEntityAccessor.getTextSetsSpaceOrGlobal(spaceKey);
        this.isReadOnlyModeActive = this.accessModeService.isReadOnlyAccessModeEnabled();
        this.baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("baseUrl", this.baseUrl);
        data.put("text_sets", this.textSets);
        data.put("css_classes", this.cssClasses);
        data.put("dropdown_groups", this.groups);
        data.put("lozenge_sets", this.lozengeSets);
        data.put("readOnlyModeActive", this.isReadOnlyModeActive);
        data.put(SPACE_ID, spaceId);
        this.render(resp, data);
    }

    private void render(HttpServletResponse resp, Map<String, Object> data) {
        String webResource = "eps.focuspro.EasyDropdownMenu:easy-dropdown-menu-configure-v6.1.0";
        try {
            this.soyRenderer.render((Appendable)resp.getWriter(), webResource, "Confluence.Sap.spaceConfig.doGet", data);
        }
        catch (Exception e) {
            log.error("Error in Task Servlet", (Throwable)e);
        }
    }

    public String doDefault() {
        return "input";
    }

    public List<DropdownSet<LozengeOption>> getLozengeSets() {
        return this.lozengeSets;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<DropdownSet<TextOption>> getTextSets() {
        return this.textSets;
    }

    public SoyTemplateRenderer getSoyRenderer() {
        return this.soyRenderer;
    }

    public List<String> getCssClasses() {
        return this.cssClasses;
    }

    public boolean getIsReadOnlyModeActive() {
        return this.isReadOnlyModeActive;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

