if (typeof Edm === "undefined") {
    Edm = {};
}
Edm.Rest = {};

/**
 * Set Resources Text Set
 */
Edm.Rest.createTextSet = function (data) {
    return $.ajax({
        type: "POST",
        url: AJS.params.contextPath + "/rest/edm/1.0/set/text",
        contentType: "application/json",
        data: JSON.stringify(data),
    }).fail((resp) => {
        errorHandler(resp);
    });
};

Edm.Rest.updateTextSet = function (data) {
    return $.ajax({
        type: "PUT",
        url: AJS.params.contextPath + "/rest/edm/1.0/set/text",
        contentType: "application/json",
        data: JSON.stringify(data)
    }).fail((resp) => {
        errorHandler(resp);
    });
};

Edm.Rest.getTextSet = function (setId) {
    const params = $.param({
        setId: setId
    });
    return $.ajax({
        type: "GET",
        url: `${Confluence.getContextPath()}/rest/edm/1.0/set/text?${params}`,
        contentType: "application/json",
        dataType: "json",
    });
};

Edm.Rest.deleteTextSet = function (setId, spaceKey) {
    const params = $.param({
        setId: setId,
        spaceKey: spaceKey
    });
    return $.ajax({
        type: "DELETE",
        url: `${Confluence.getContextPath()}/rest/edm/1.0/set/text?${params}`,
    }).fail((resp) => {
        errorHandler(resp);
    });
};

/**
 * Set Resources Status Set
 */
Edm.Rest.createStatusSet = function (data) {
    return $.ajax({
        type: "POST",
        url: AJS.params.contextPath + "/rest/edm/1.0/set/status",
        contentType: "application/json",
        data: JSON.stringify(data),
    }).fail((resp) => {
        errorHandler(resp);
    });
};

Edm.Rest.updateStatusSet = function (data) {
    return $.ajax({
        type: "PUT",
        url: AJS.params.contextPath + "/rest/edm/1.0/set/status",
        contentType: "application/json",
        data: JSON.stringify(data)
    }).fail((resp) => {
        errorHandler(resp);
    });
};

Edm.Rest.getStatusSet = function (setId) {
    const params = $.param({
        setId: setId
    });
    return $.ajax({
        type: "GET",
        url: `${Confluence.getContextPath()}/rest/edm/1.0/set/status?${params}`,
        contentType: "application/json",
        dataType: "json",
    });
};

Edm.Rest.deleteStatusSet = function (setId, spaceKey) {
    const params = $.param({
        setId: setId,
        spaceKey: spaceKey
    });
    return $.ajax({
        type: "DELETE",
        url: `${Confluence.getContextPath()}/rest/edm/1.0/set/status?${params}`,
    }).fail((resp) => {
        errorHandler(resp);
    });
};

/**
 * REST API for History
 */
Edm.Rest.getStatusHistory = function (setId) {
    const params = $.param({
        setId: setId
    });
    return $.ajax({
        type: "GET",
        url: `${Confluence.getContextPath()}/rest/edm/1.0/history/status?${params}`
    });
};

Edm.Rest.getTextHistory = function (setId) {
    const params = $.param({
        setId: setId
    });
    return $.ajax({
        type: "GET",
        url: `${Confluence.getContextPath()}/rest/edm/1.0/history/text?${params}`
    });
};

Edm.Rest.restoreStatusOption = function (restoreDto) {
    return $.ajax({
        type: "POST",
        url: `${Confluence.getContextPath()}/rest/edm/1.0/history/status/restoreOption`,
        contentType: "application/json",
        data: JSON.stringify(restoreDto)
    }).fail((resp) => {
        errorHandler(resp);
    });
};

Edm.Rest.restoreTextOption = function (restoreDto) {
    return $.ajax({
        type: "POST",
        url: `${Confluence.getContextPath()}/rest/edm/1.0/history/text/restoreOption`,
        contentType: "application/json",
        data: JSON.stringify(restoreDto)
    }).fail((resp) => {
        errorHandler(resp);
    });
};

Edm.Rest.post = function (url, input, success) {
    success = typeof success !== "undefined" ? success : void (0);
    AJS.$.ajax({
        type: "POST",
        url: url,
        contentType: "application/json",
        dataType: "json",
        data: JSON.stringify(input),
    }).done(
        success
    ).fail((resp) => {
        errorHandler(resp);
    });
};

Edm.Rest.updatePredefinedMacro = function (data) {
    $.ajax({
        type: "POST",
        dataType: "json",
        contentType: "application/json",
        url: AJS.params.baseUrl + "/rest/edm/1.0/page/update/predefined-macro",
        data: JSON.stringify(data),
    }).done((respDto) => {
        successFlagHandler(respDto);
    }).fail((resp) => {
        errorHandler(resp);
    });
};

Edm.Rest.updateNonPredefinedMacro = function (data) {
    $.ajax({
        type: "POST",
        dataType: "json",
        contentType: "application/json",
        url: AJS.params.baseUrl + "/rest/edm/1.0/page/update/non-predefined-macro",
        data: JSON.stringify(data),
    }).done((respDto) => {
        successFlagHandler(respDto);
    }).fail((resp) => {
        errorHandler(resp);
    });
};

Edm.Rest.get = function (url, success) {
    success = typeof success !== "undefined" ? success : void (0);
    AJS.$.ajax({
        method: "GET",
        url: url,
        dataType: "json",
    }).done(
        success
    ).fail((resp) => {
        errorHandler(resp);
    });
};

Edm.Rest.getDataJson = function (data, success) {
    $.ajax({
        type: "POST",
        dataType: "json",
        contentType: "application/json",
        url: AJS.params.baseUrl + "/rest/edm/1.0/data-migration/get-data-json",
        data: JSON.stringify(data),
    }).done(
        success
    ).fail((resp) => {
        errorHandler(resp);
    });
}

Edm.Rest.importDataJson = function (data) {
    $.ajax({
        type: "PUT",
        dataType: "json",
        contentType: "application/json",
        url: AJS.params.baseUrl + "/rest/edm/1.0/data-migration/save-data-json",
        data: JSON.stringify(data),
    }).done(() => {
        Edm.Flag.importSettingsSuccessFlag();
    }).fail((resp) => {
        errorHandler(resp);
    });
}

function successFlagHandler(respDto) {
    if (!respDto.isSuppressNotifications) {
        Edm.Flag.updateDropdownSuccessFlag();
    }
    if (!respDto.macroUpdatedInDraft) {
        Edm.Flag.dropdownNotUpdatedInDraft();
    }
}

function errorHandler(resp) {
    let data = resp.responseText;
    if (resp.status === 405 && data.reason === "READ_ONLY") {
        Edm.Flag.readOnlyModeFlag();
    } else {
        Edm.Flag.errorOutput(resp);
    }
}
